/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzYIM;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.zzWdc;
import com.aspose.words.zzXDW;
import com.aspose.words.zzXN;
import com.aspose.words.zzXPH;
import com.aspose.words.zzXpT;
import com.aspose.words.zzYMX;
import com.aspose.words.zzZ8b;
import com.aspose.words.zzZLt;
import com.aspose.words.zzeq;
import com.aspose.words.zzvF;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzXN zzVYv;

    ChartSeriesCollection(zzXN dmlChart) {
        this.zzVYv = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYv.zzZb9().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYv.zzZb9().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVYv.zzZb9().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVYv.zzZb9().clear();
        this.zza6(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXDP(seriesName, values);
        chartSeries.zzKC().zzWOR(ChartSeriesCollection.zzZNf(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXDP(seriesName, yValues);
        chartSeries.zzKC().zzWOR(ChartSeriesCollection.zzWOR(xValues));
        return chartSeries;
    }

    private ChartSeries zzXDP(String string, zzYIM[] zzYIMArray, double[] dArray) {
        if (zzYIMArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYIMArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYIMArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXDP(string, dArray);
        chartSeries.zzKC().zzWOR(ChartSeriesCollection.zzXDP(zzYIMArray));
        if (!this.zzVYv.zzXjS()) {
            this.zza6(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXDP(seriesName, zzYIM.zzXDP(dates), values);
    }

    private void zza6(boolean bl) {
        zzeq zzeq2 = zzZwy.zzXDP((Object)this.zzVYv, zzeq.class);
        if (zzeq2 != null && zzeq2.zzWM4().zzXJf()) {
            zzeq2.zzWM4().zzmu().zzZNf(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzVYv.zzY4c() != 15) {
            this.zzVYv.zzXN6(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXDP(seriesName, yValues);
        chartSeries.zzXsN().zzne().zzZNf(3, this.zzVYv.zzXLV());
        chartSeries.zzKC().zzWOR(ChartSeriesCollection.zzWOR(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWtz().zzWOR(ChartSeriesCollection.zzWOR(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzXDP(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzVYv);
        chartSeries.setName(string);
        this.zzZNm(chartSeries);
        chartSeries.zzVZU(this.zzVYv.zzva().zzYUh() + 1);
        chartSeries.zzWYQ(this.zzVYv.zzva().zzY64() + 1);
        chartSeries.zzXQP().zzWOR(ChartSeriesCollection.zzWOR(dArray));
        this.zzVYv.zzYCF().zzVTu();
        this.zzVYv.zzZb9().zzWYT(chartSeries);
        return chartSeries;
    }

    private void zzZNm(ChartSeries chartSeries) {
        chartSeries.zzXsN().zzne().zzZNf(5, new zzvF());
        switch (this.zzVYv.zzY4c()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXDP(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXDP(chartSeries, 5);
                ChartSeriesCollection.zzCV(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXDP(chartSeries, 1);
                ChartSeriesCollection.zzCV(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzZTs(chartSeries);
            }
        }
    }

    private static void zzZTs(ChartSeries chartSeries) {
        zzvF zzvF2 = new zzvF();
        zzvF2.setOutline(new zzWdc());
        zzZ8b zzZ8b2 = new zzZ8b();
        zzZ8b2.zzXSf(1);
        zzvF2.getOutline().setFill(new zzXpT(zzZ8b2));
        zzvF2.getOutline().zzZn9(19050.0);
        chartSeries.zzXsN().zzne().zzZNf(5, zzvF2);
    }

    private static void zzCV(ChartSeries chartSeries) {
        zzvF zzvF2 = new zzvF();
        zzvF2.setOutline(new zzWdc());
        zzvF2.getOutline().setFill(new zzXDW());
        zzvF2.getOutline().setEndCap(0);
        zzvF2.getOutline().zzZn9(19050.0);
        chartSeries.zzXsN().zzne().zzZNf(5, zzvF2);
    }

    private static void zzXDP(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zz8x());
        chartMarker.zzom().zzZNf(0, n);
        chartSeries.zzXsN().zzne().zzZNf(4, chartMarker);
    }

    private static zzZLt zzWOR(double[] dArray) {
        int n = 0;
        zzZLt zzZLt2 = new zzZLt(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZLt2.zzDu(new zzYMX(n, d, "General"));
            }
            ++n;
        }
        zzZLt2.zzYY1(dArray.length);
        return zzZLt2;
    }

    private static zzZLt zzXDP(zzYIM[] zzYIMArray) {
        int n = 0;
        zzZLt zzZLt2 = new zzZLt(2);
        zzYIM[] zzYIMArray2 = zzYIMArray;
        int n2 = zzYIMArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYIM zzYIM2 = zzYIMArray2[i];
            zzZLt2.zzDu(new zzYMX(n++, zzYIM2.zzYU8(), "m/d/yyyy"));
        }
        zzZLt2.zzYY1(zzYIMArray.length);
        return zzZLt2;
    }

    private static zzZLt zzZNf(String[] stringArray) {
        int n = 0;
        zzZLt zzZLt2 = new zzZLt(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZLt2.zzDu(new zzXPH(n++, string));
        }
        zzZLt2.zzYY1(stringArray.length);
        return zzZLt2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYv.zzZb9().getCount();
    }
}

