/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j;

import java.util.Locale;

public interface Axis {
    public static final Standard FILTER = Standard.FILTER;
    public static final Standard COLUMNS = Standard.COLUMNS;
    public static final Standard ROWS = Standard.ROWS;
    public static final Standard PAGES = Standard.PAGES;
    public static final Standard SECTIONS = Standard.SECTIONS;
    public static final Standard CHAPTERS = Standard.CHAPTERS;

    public String name();

    public boolean isFilter();

    public int axisOrdinal();

    public String getCaption(Locale var1);

    public static class Factory {
        private static final Standard[] STANDARD_VALUES = Standard.values();

        public static Axis forOrdinal(final int ordinal) {
            if (ordinal < -1) {
                throw new IllegalArgumentException("Axis ordinal must be -1 or higher");
            }
            if (ordinal + 1 < STANDARD_VALUES.length) {
                return STANDARD_VALUES[ordinal + 1];
            }
            return new Axis(){

                public String toString() {
                    return this.name();
                }

                public String name() {
                    return "AXIS(" + ordinal + ")";
                }

                public boolean isFilter() {
                    return false;
                }

                public int axisOrdinal() {
                    return ordinal;
                }

                public String getCaption(Locale locale) {
                    return this.name();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Standard implements Axis
    {
        FILTER,
        COLUMNS,
        ROWS,
        PAGES,
        CHAPTERS,
        SECTIONS;


        @Override
        public int axisOrdinal() {
            return this.ordinal() - 1;
        }

        @Override
        public boolean isFilter() {
            return this == FILTER;
        }

        @Override
        public String getCaption(Locale locale) {
            return this.name();
        }
    }
}

