/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.Arrays;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.NewJCall;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class NarrowedJType
extends AbstractJType {
    private final AbstractJType erased;
    private final JType[] args;

    public NarrowedJType(AbstractJType erased, JType[] args) {
        this.erased = erased;
        this.args = args;
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof NarrowedJType && this.equals((NarrowedJType)other);
    }

    private boolean equals(NarrowedJType other) {
        return this.erased.equals(other.erased) && Arrays.equals(this.args, other.args);
    }

    @Override
    public int hashCode() {
        return this.erased.hashCode() * 17 + Arrays.hashCode(this.args);
    }

    @Override
    public String simpleName() {
        return this.erased.simpleName();
    }

    @Override
    public JExpr _class() {
        return this.erased._class();
    }

    @Override
    public JExpr _this() {
        return this.erased._this();
    }

    @Override
    public JExpr _super() {
        return this.erased._super();
    }

    @Override
    public JCall _new() {
        return new NewJCall(this);
    }

    @Override
    public JCall _new(JExpr dim) {
        JCall call = this.erasure()._new();
        for (JType arg : this.args) {
            call.typeArg(arg);
        }
        return call;
    }

    @Override
    public JType typeArg(JType ... args) {
        return new NarrowedJType(this.erased, NarrowedJType.concat(this.args, args));
    }

    private static JType[] concat(JType[] a, JType[] b) {
        if (a.length == 0) {
            return b;
        }
        int al = a.length;
        int bl = b.length;
        JType[] c = Arrays.copyOf(a, al + bl);
        System.arraycopy(b, 0, c, al, bl);
        return c;
    }

    @Override
    public JType[] typeArgs() {
        return this.args;
    }

    @Override
    public JType erasure() {
        return this.erased;
    }

    @Override
    public JCall call(String name) {
        return this.erasure().call(name);
    }

    @Override
    public JType nestedType(String name) {
        return this.erasure().nestedType(name);
    }

    @Override
    void writeDirect(SourceFileWriter sourceFileWriter) throws IOException {
        sourceFileWriter.write(this.erasure());
        JType[] args = this.args;
        int len = args.length;
        if (len > 0) {
            sourceFileWriter.write(Tokens$.PUNCT.ANGLE.OPEN);
            JType type = args[0];
            sourceFileWriter.write(type);
            for (int i = 1; i < len; ++i) {
                sourceFileWriter.write(FormatPreferences.Space.BEFORE_COMMA);
                sourceFileWriter.write(Tokens$.PUNCT.COMMA);
                sourceFileWriter.write(FormatPreferences.Space.AFTER_COMMA_TYPE_ARGUMENT);
                type = args[i];
                sourceFileWriter.write(type);
            }
            sourceFileWriter.write(Tokens$.PUNCT.ANGLE.CLOSE);
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.erased.toString());
        b.append('<');
        for (int i = 0; i < this.args.length; ++i) {
            JType arg = this.args[i];
            b.append(arg);
            if (i >= this.args.length - 1) continue;
            b.append(",");
        }
        b.append('>');
        return b.toString();
    }
}

