/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.svn;

import br.com.jarch.svn.BaseSvn;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.svn.SvnUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class StatusSvn
extends BaseSvn {
    private static final long serialVersionUID = -7046346153335029307L;

    public StatusSvn(List<String> log, String login, String senha, OutputStream outputStream) {
        super(log, login, senha, outputStream);
    }

    public List<StatusArquivoForm> status(File pastaTrabalho) throws Exception {
        final ArrayList<StatusArquivoForm> listaStatusArquivo = new ArrayList<StatusArquivoForm>();
        if (!pastaTrabalho.exists()) {
            return listaStatusArquivo;
        }
        File pastaSvn = new File(pastaTrabalho.getAbsolutePath().concat("/.svn"));
        if (!pastaSvn.exists()) {
            return listaStatusArquivo;
        }
        try {
            SVNStatusClient statusClient = this.getStatusClient();
            this.formatBegin("STATUS");
            ISVNStatusHandler statusHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus svnStatus) {
                    SVNStatusType statusType = svnStatus.getNodeStatus();
                    String mensagem = "STATUS: " + svnStatus.getFile().getPath() + " - " + statusType.toString().toUpperCase();
                    System.out.println(mensagem);
                    if (statusType != SVNStatusType.STATUS_NORMAL && statusType != SVNStatusType.STATUS_IGNORED && !SvnUtils.ignoraCommitArquivoOuPasta(svnStatus.getFile())) {
                        StatusSvn.this.formatMiddle(mensagem);
                        StatusArquivoForm statusArquivoForm = new StatusArquivoForm(statusType.toString().toUpperCase(), svnStatus.getFile().getPath());
                        listaStatusArquivo.add(statusArquivoForm);
                    }
                }
            };
            statusClient.doStatus(pastaTrabalho, SVNRevision.HEAD, SVNDepth.INFINITY, false, false, false, false, statusHandler, null);
            this.formatBegin("FIM");
        }
        catch (SVNException e) {
            throw new Exception(e.getMessage());
        }
        return listaStatusArquivo;
    }
}

