/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.param;

import br.com.jarch.core.jpa.param.ParamFieldValue;
import br.com.jarch.core.jpa.param.ParamFieldValues;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.ConditionSearchType;
import java.util.Map;

public final class ParamFieldValueBuilder<E extends IIdentity> {
    private final ParamFieldValues paramFieldValues;

    private ParamFieldValueBuilder(Class<E> classEntity) {
        this.paramFieldValues = new ParamFieldValues(classEntity);
    }

    public static <E extends IIdentity> ParamFieldValueBuilder<E> newInstance(Class<E> classEntity) {
        return new ParamFieldValueBuilder<E>(classEntity);
    }

    public ParamFieldValueBuilder<E> addFieldValueEqual(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueEqual(String attribute, Object value, boolean caseSensitive) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.EQUAL, value, caseSensitive));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueLarger(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.LARGER, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueLess(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.LESS, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueDifferent(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.DIFFERENT, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueLargerEqual(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.LARGER_EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueLessEqual(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.LESS_EQUAL, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueContains(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.CONTAINS, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addFieldValueNotContains(String attribute, Object value) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.NOT_CONTAINS, value));
        return this;
    }

    public ParamFieldValueBuilder<E> addExistsField(String attribute) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.EXISTS));
        return this;
    }

    public ParamFieldValueBuilder<E> addNotExistsField(String attribute) {
        this.paramFieldValues.add(this.create(attribute, ConditionSearchType.NOT_EXISTS));
        return this;
    }

    public ParamFieldValueBuilder<E> addConcatWhere(String where) {
        return this.addConcatWhere(where, null);
    }

    public ParamFieldValueBuilder<E> addConcatWhere(String where, Map<String, Object> paramValues) {
        return this.addJpql(where, paramValues);
    }

    public ParamFieldValueBuilder<E> addJpql(String where) {
        return this.addJpql(where, null);
    }

    public ParamFieldValueBuilder<E> addJpql(String where, Map<String, Object> paramValues) {
        ParamFieldValue paramFieldValueConcatWhere = new ParamFieldValue();
        paramFieldValueConcatWhere.setConditionSearch(ConditionSearchType.JPQL);
        paramFieldValueConcatWhere.setClause(where);
        if (paramValues != null) {
            paramValues.forEach(paramFieldValueConcatWhere::addParamValue);
        }
        this.paramFieldValues.add(paramFieldValueConcatWhere);
        return this;
    }

    public ParamFieldValues build() {
        return this.paramFieldValues;
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch) {
        return this.create(attribute, conditionSearch, null, true);
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch, Object value) {
        return this.create(attribute, conditionSearch, value, true);
    }

    private ParamFieldValue create(String attribute, ConditionSearchType conditionSearch, Object value, boolean caseSensitive) {
        ParamFieldValue paramFieldValue = new ParamFieldValue();
        paramFieldValue.setAttribute(attribute);
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        paramFieldValue.setCaseSensitive(caseSensitive);
        return paramFieldValue;
    }
}

