/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.util;

import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static String getMessageInfo() {
        return MessageUtils.getMessages(FacesMessage.SEVERITY_INFO);
    }

    public static String getMessageError() {
        return MessageUtils.getMessages(FacesMessage.SEVERITY_ERROR);
    }

    public static String getMessageWarn() {
        return MessageUtils.getMessages(FacesMessage.SEVERITY_WARN);
    }

    public static String getMessageFatal() {
        return MessageUtils.getMessages(FacesMessage.SEVERITY_FATAL);
    }

    private static String getMessages(FacesMessage.Severity severity) {
        Object result = "";
        for (FacesMessage facesMessage : FacesContext.getCurrentInstance().getMessageList()) {
            Object messageNew;
            Object[] objects;
            if (!facesMessage.getSeverity().equals(severity) || facesMessage.getDetail().isEmpty() && facesMessage.getSummary().isEmpty()) continue;
            Object summary = StringUtils.nullAsBlank((Object)facesMessage.getSummary());
            summary = MessageUtils.formatText(facesMessage, (String)summary);
            Object detail = StringUtils.nullAsBlank((Object)facesMessage.getDetail());
            if (!((String)(detail = MessageUtils.formatText(facesMessage, (String)detail))).startsWith("<b>") && ReflectionUtils.isAttribute((Object)facesMessage, (String)"parameters", (boolean)true) && (objects = (Object[])ReflectionUtils.getValueByName((Object)facesMessage, (String)"parameters")) != null && objects.length > 1 && ((String)summary).equals(detail) && !((String)detail).startsWith(objects[1].toString())) {
                summary = detail = "<b>" + String.valueOf(objects[1]) + "</b>: " + (String)detail;
            }
            if (!((String)(messageNew = (String)(((String)summary).isEmpty() || ((String)summary).equals(detail) ? "" : "<strong>" + (String)summary + "</strong>: ") + (String)detail + "<br/>")).contains("<strong>") && StringUtils.count((String)messageNew, (String)":") == 1 && ((String)messageNew).indexOf(":") < ((String)messageNew).length() / 2) {
                messageNew = "<strong>" + ((String)messageNew).replaceFirst(":", "</strong>:");
            }
            messageNew = ((String)messageNew).replace("Erro de valida\u00e7\u00e3o: o valor \u00e9 necess\u00e1rio.", "Preenchimento obrigat\u00f3rio.");
            messageNew = ((String)messageNew).replace(": \u00e9 de preenchimento obrigat\u00f3rio.", ": Preenchimento obrigat\u00f3rio.");
            if (!((String)(messageNew = ((String)messageNew).replace("'", "").replace("\n", " "))).contains("<strong>") && StringUtils.count((String)messageNew, (String)":") == 1) {
                messageNew = "<strong>" + ((String)messageNew).replaceFirst(":", "</strong>:");
            }
            if (((String)result).contains((CharSequence)messageNew)) continue;
            result = (String)result + (String)messageNew;
        }
        return ((String)result).isBlank() ? " " : result;
    }

    private static String formatText(FacesMessage facesMessage, String text) {
        String string = text = text.startsWith("label.") || text.startsWith("message.") ? BundleUtils.messageBundle(text) : text;
        if (text.startsWith("???")) {
            text = facesMessage.getDetail();
            text = text.startsWith("label.") || text.startsWith("message.") ? BeanValidationUtils.messageBundle(text) : text;
        }
        return text;
    }
}

