/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.communication;

import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.communication.CommunicationAttachEntity;
import br.com.jarch.core.crud.communication.CommunicationAttachEntity_;
import br.com.jarch.core.crud.communication.CommunicationAttachJpqlBuilder;
import br.com.jarch.core.crud.communication.CommunicationDaoHelper;
import br.com.jarch.core.crud.communication.CommunicationEntity;
import br.com.jarch.core.crud.communication.CommunicationEntity_;
import br.com.jarch.core.crud.communication.CommunicationRepository;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.core.wrapper.LongWrapper;
import jakarta.persistence.metamodel.Attribute;
import jakarta.transaction.Transactional;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Set;
import java.util.stream.Collectors;

@JArchDao
public class CommunicationDao
extends CrudDao<CommunicationEntity>
implements CommunicationRepository {
    @Override
    public Set<Long> searchAllExpiration() {
        return this.getClientJpql().select((Attribute<CommunicationEntity, ?>)CommunicationEntity_.id).where().lessThan(CommunicationEntity_.expiration, LocalDate.now()).collect().list(LongWrapper.class).stream().map(LongWrapper::getLongValue).collect(Collectors.toSet());
    }

    public Set<CommunicationAttachEntity> searchAllAttachBy(CommunicationEntity communication) {
        return CommunicationAttachJpqlBuilder.newInstance().select(new Attribute[]{CommunicationAttachEntity_.id, CommunicationAttachEntity_.fileName}).where().equalsTo(CommunicationAttachEntity_.communication, communication).collect().set();
    }

    @Override
    public CommunicationAttachEntity searchAttachWithBinary(CommunicationAttachEntity attach) {
        return CommunicationAttachJpqlBuilder.newInstance().where().equalsTo(CommunicationAttachEntity.class, (Object)attach).collect().single();
    }

    @Override
    @Transactional
    public CommunicationAttachEntity newAttach(CommunicationEntity communication) {
        CommunicationAttachEntity communicationAttachEntity = new CommunicationAttachEntity();
        communicationAttachEntity.setCommunication(communication);
        this.getEntityManager().persist((Object)communicationAttachEntity);
        return communicationAttachEntity;
    }

    @Override
    @Transactional
    public void saveAttachFromBytes(CommunicationAttachEntity communicationAttach, String fileName, byte[] bytes) {
        CommunicationDaoHelper.getInstance().saveAttachFromBytes(communicationAttach, fileName, bytes);
    }

    @Override
    @Transactional
    public void saveAttachFromFile(CommunicationAttachEntity communicationAttach, String fileName, File file) {
        CommunicationDaoHelper.getInstance().saveAttachFromFile(communicationAttach, fileName, file);
    }

    private byte[] readFileAsByteArray(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] chunk = new byte[8192];
                while ((bytesRead = fis.read(chunk)) != -1) {
                    buffer.write(chunk, 0, bytesRead);
                }
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
    }
}

