/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchLookup;
import br.com.jarch.core.annotation.JArchNoCloneId;
import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.batch.BatchEntity;
import br.com.jarch.core.crud.batch.LogEntity;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import br.com.jarch.util.DateUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.envers.Audited;

@Audited
@Table(name="tb_batch_execution", indexes={@Index(columnList="dh_start", name="dx_batchexecutiondhsta"), @Index(columnList="dh_end", name="dx_batchexecutiondhend"), @Index(columnList="sn_success", name="dx_batchexecutionsnsuc")})
@Entity(name="execution")
@SequenceGenerator(name="ExecutionIdSequence", sequenceName="sq_idbatchexecution", allocationSize=1)
@JArchLookup(codeAttribute="id", descriptionAttribute="descritionLookup")
@JArchOrderBy(fields={@JArchOrderByField(value="id", desc=true)})
public class ExecutionEntity
extends CrudMultiTenantEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="ExecutionIdSequence")
    @Column(name="id_batchexecution")
    private Long id;
    @ManyToOne
    @JoinColumn(name="id_batch", nullable=false)
    private BatchEntity batch;
    @Column(name="dh_start", nullable=false)
    @Convert(converter=LocalDateTimeJpaConverter.class)
    @JArchValidRequired(value="label.startTime")
    private LocalDateTime startTime;
    @Column(name="dh_end")
    @Convert(converter=LocalDateTimeJpaConverter.class)
    private LocalDateTime endTime;
    @Column(name="sn_success", length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean success;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="execution", orphanRemoval=true)
    @JArchNoCloneId
    private Set<LogEntity> listaLog;

    public ExecutionEntity() {
    }

    public ExecutionEntity(Long id, LocalDateTime startTime, LocalDateTime endTime, Boolean success) {
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.success = success;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public BatchEntity getBatch() {
        return this.batch;
    }

    public void setBatch(BatchEntity batch) {
        this.batch = batch;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public Set<LogEntity> getListaLog() {
        return this.listaLog;
    }

    public void setListaLog(Set<LogEntity> listaLog) {
        this.listaLog = listaLog;
    }

    public void addListaLog(LogEntity log) {
        if (this.listaLog == null) {
            this.listaLog = new HashSet<LogEntity>();
        }
        this.listaLog.add(log);
    }

    @Override
    public String getDescriptionLookup() {
        return this.batch.getCode() + " - " + this.batch.getName() + " - " + DateUtils.formatddMMyyyyHHmm((LocalDateTime)this.startTime);
    }
}

