/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchLookup;
import br.com.jarch.core.annotation.JArchNoCloneId;
import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import br.com.jarch.core.annotation.JArchValidExclusives;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.envers.Audited;

@Audited
@Table(name="tb_batch", indexes={@Index(columnList="cd_batch", name="dx_batchcdbat"), @Index(columnList="nm_batch", name="dx_batchnmbat")})
@Entity(name="batch")
@SequenceGenerator(name="BatchIdSequence", sequenceName="sq_idbatch", allocationSize=1)
@JArchOrderBy(fields={@JArchOrderByField(value="name")})
@JArchLookup(codeAttribute="code", descriptionAttribute="name")
@JArchValidExclusives(fields={"code", "name"})
public class BatchEntity
extends CrudMultiTenantEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="BatchIdSequence")
    @Column(name="id_batch")
    private Long id;
    @Column(name="cd_batch", nullable=false, length=100)
    @JArchValidRequired(value="label.code")
    @Size(max=100, message="{message.maxSizeExceeded}")
    private @Size(max=100, message="{message.maxSizeExceeded}") String code;
    @Column(name="nm_batch", nullable=false, length=500)
    @JArchValidRequired(value="label.name")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="batch", orphanRemoval=true)
    @JArchNoCloneId
    private Set<ExecutionEntity> listaExecution;

    public BatchEntity() {
    }

    public BatchEntity(Long id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<ExecutionEntity> getListaExecution() {
        return this.listaExecution;
    }

    public void setListaExecution(Set<ExecutionEntity> listaExecution) {
        this.listaExecution = listaExecution;
    }

    public void addListaExecution(ExecutionEntity execution) {
        if (this.listaExecution == null) {
            this.listaExecution = new HashSet<ExecutionEntity>();
        }
        this.listaExecution.add(execution);
    }
}

