/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.type;

import java.util.Arrays;

public enum FileType {
    PDF("application/pdf"),
    EXCEL("application/vnd.ms-excel"),
    CSV("text/csv"),
    TXT("text/plain"),
    DOC("application/msword"),
    ZIP("application/zip"),
    XML("application/xml");

    private final String contentType;

    private FileType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.name();
    }

    public static FileType fromContentType(String contentType) {
        return Arrays.stream(FileType.values()).filter(fileType -> fileType.getContentType().equals(contentType)).findAny().orElse(null);
    }

    public String getExtension() {
        if (this == EXCEL) {
            return "xlsx";
        }
        return this.name().toLowerCase();
    }

    public boolean isPdf() {
        return this == PDF;
    }

    public boolean isExcel() {
        return this == EXCEL;
    }
}

