/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.type;

import br.com.jarch.core.jpa.api.IAggregateJpql;
import br.com.jarch.core.model.type.OrderType;
import jakarta.persistence.metamodel.Attribute;
import java.io.Serializable;

public final class FieldOrder
implements Serializable {
    private final String field;
    private final OrderType order;
    private final boolean addPrefix;

    private FieldOrder(String field, OrderType order) {
        this.field = field;
        this.order = order;
        this.addPrefix = !field.contains(".") && !field.contains("(");
    }

    public static FieldOrder asc(String field) {
        return new FieldOrder(field, OrderType.ASC);
    }

    public static FieldOrder asc(Attribute<?, ?> attribute) {
        return new FieldOrder(attribute.getName(), OrderType.ASC);
    }

    public static FieldOrder asc(IAggregateJpql aggregate) {
        return new FieldOrder(aggregate.getCommand(), OrderType.ASC);
    }

    public static FieldOrder desc(String field) {
        return new FieldOrder(field, OrderType.DESC);
    }

    public static FieldOrder desc(Attribute<?, ?> attribute) {
        return new FieldOrder(attribute.getName(), OrderType.DESC);
    }

    public static FieldOrder desc(IAggregateJpql aggregate) {
        return new FieldOrder(aggregate.getCommand(), OrderType.DESC);
    }

    public String getField() {
        return this.field;
    }

    public OrderType getOrder() {
        return this.order;
    }

    public boolean isAsc() {
        return OrderType.ASC.equals((Object)this.order);
    }

    public boolean isDesc() {
        return OrderType.DESC.equals((Object)this.order);
    }

    public boolean isAddPrefix() {
        return this.addPrefix;
    }
}

