/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.inspect;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SqlJoinRemover {
    SqlJoinRemover() {
    }

    public static String removeJoinsAndWhereAssociations(String sql) {
        if (sql == null) {
            return null;
        }
        String normalized = sql.replaceAll("[\\t\\f\\r]+", " ");
        Pattern joinAliasPattern = Pattern.compile("(?i)\\b(?:CROSS|INNER|LEFT|RIGHT|FULL)?\\s*JOIN\\s+[^\\s]+\\s+([a-zA-Z_][a-zA-Z0-9_]*)\\b");
        Pattern joinBlockPattern = Pattern.compile("(?i)\\b(?:CROSS|INNER|LEFT|RIGHT|FULL)?\\s*JOIN\\s+[^\\n]+?(?=\\b(?:CROSS\\s+JOIN|INNER\\s+JOIN|LEFT\\s+JOIN|RIGHT\\s+JOIN|FULL\\s+JOIN|JOIN|WHERE|GROUP\\s+BY|ORDER\\s+BY|HAVING|$))");
        LinkedHashSet<String> joinAliases = new LinkedHashSet<String>();
        Matcher aliasMatcher = joinAliasPattern.matcher(normalized);
        while (aliasMatcher.find()) {
            joinAliases.add(aliasMatcher.group(1));
        }
        String withoutJoins = joinBlockPattern.matcher(normalized).replaceAll(" ");
        int whereIdx = SqlJoinRemover.indexOfWordIgnoreCase(withoutJoins, "WHERE");
        if (whereIdx < 0 || joinAliases.isEmpty()) {
            return SqlJoinRemover.cleanupSql(withoutJoins);
        }
        int tailIdx = SqlJoinRemover.findFirstKeywordIndexIgnoreCase(withoutJoins, whereIdx, new String[]{"GROUP BY", "ORDER BY", "HAVING"});
        String head = withoutJoins.substring(0, whereIdx);
        String whereClause = tailIdx >= 0 ? withoutJoins.substring(whereIdx + 5, tailIdx) : withoutJoins.substring(whereIdx + 5);
        String tail = tailIdx >= 0 ? withoutJoins.substring(tailIdx) : "";
        String cleanedWhere = SqlJoinRemover.removeJoinEqualityConditions(whereClause, joinAliases);
        cleanedWhere = SqlJoinRemover.cleanupBooleanWhere(cleanedWhere);
        String rebuilt = cleanedWhere.trim().isEmpty() ? head + tail : head + " WHERE " + cleanedWhere + tail;
        return SqlJoinRemover.cleanupSql(rebuilt);
    }

    private static String removeJoinEqualityConditions(String whereClause, Set<String> joinAliases) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = Pattern.compile("(?i)\\b(AND|OR)\\b").matcher(whereClause);
        int last = 0;
        while (m.find()) {
            String before = whereClause.substring(last, m.start());
            String op = whereClause.substring(m.start(), m.end());
            tokens.add(before);
            tokens.add(op);
            last = m.end();
        }
        tokens.add(whereClause.substring(last));
        Pattern eqColCol = Pattern.compile("^\\s*\\(?\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\.[a-zA-Z_][a-zA-Z0-9_]*\\s*=\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\.[a-zA-Z_][a-zA-Z0-9_]*\\s*\\)?\\s*$");
        ArrayList<String> kept = new ArrayList<String>();
        for (String t : tokens) {
            if (t.equalsIgnoreCase("AND") || t.equalsIgnoreCase("OR")) {
                kept.add(t);
                continue;
            }
            String trimmed = t.trim();
            if (trimmed.isEmpty()) continue;
            Matcher mm = eqColCol.matcher(trimmed);
            if (mm.matches()) {
                String a1 = mm.group(1);
                String a2 = mm.group(2);
                if (joinAliases.contains(a1) || joinAliases.contains(a2)) continue;
            }
            kept.add(t);
        }
        String joined = String.join((CharSequence)" ", kept);
        return SqlJoinRemover.cleanupBooleanWhere(joined);
    }

    private static String cleanupBooleanWhere(String where) {
        String s = where.trim();
        s = s.replaceAll("(?i)^(AND|OR)\\b\\s*", "");
        s = s.replaceAll("\\s*\\b(AND|OR)$", "");
        s = s.replaceAll("(?i)\\b(AND|OR)\\b\\s*\\b(AND|OR)\\b", "$1");
        s = s.replaceAll("\\(\\s*\\)", "");
        s = s.replaceAll("\\s+", " ").trim();
        return s;
    }

    private static String cleanupSql(String sql) {
        String s = sql.replaceAll("[ \\t\\f\\r]+", " ");
        s = s.replaceAll("\\s+(?i)(WHERE|GROUP BY|ORDER BY|HAVING)", " $1");
        s = s.replaceAll("(?i)\\bWHERE\\s*$", "");
        return s.trim();
    }

    private static int indexOfWordIgnoreCase(String text, String word) {
        Matcher m = Pattern.compile("(?i)\\b" + Pattern.quote(word) + "\\b").matcher(text);
        return m.find() ? m.start() : -1;
    }

    private static int findFirstKeywordIndexIgnoreCase(String text, int fromIndex, String[] keywords) {
        int min = -1;
        for (String kw : keywords) {
            int idx = SqlJoinRemover.indexOfWordIgnoreCase(text.substring(fromIndex), kw);
            if (idx < 0) continue;
            int abs = fromIndex + idx;
            if (min >= 0 && abs >= min) continue;
            min = abs;
        }
        return min;
    }

    public static void main(String[] args) {
        String sql = "SELECT a.col, b.col FROM t a INNER JOIN t2 b ON a.id=b.id LEFT JOIN t3 c ON c.a=a.id CROSS JOIN t4 d WHERE a.flag=1 AND a.id=b.id AND c.x=a.x AND d.y=a.y AND a.z>10 ORDER BY a.col";
        System.out.println(SqlJoinRemover.removeJoinsAndWhereAssociations(sql));
        sql = "SELECT A.COL, B.COL FROM T A INNER JOIN T2 B ON A.ID=B.ID LEFT JOIN T3 C ON C.A=A.ID CROSS JOIN T4 D WHERE A.FLAG=1 AND A.ID=B.ID AND C.X=A.X AND D.Y=A.Y AND A.Z>10 ORDER BY A.COL";
        System.out.println(SqlJoinRemover.removeJoinsAndWhereAssociations(sql));
        sql = "select a.col, b.col from t a inner join t2 b on a.id=b.id left join t3 c on c.a=a.id cross join t4 d where a.flag=1 and a.id=b.id and c.x=a.x and d.y=a.y and a.z>10 order by a.col";
        System.out.println(SqlJoinRemover.removeJoinsAndWhereAssociations(sql));
    }
}

