/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.exception;

import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseException
extends RuntimeException {
    private final List<Exception> listExceptions = new ArrayList<Exception>();

    public BaseException() {
    }

    public BaseException(String message) {
        super(message);
        this.addMessageErro(message);
    }

    public BaseException(String message, Throwable cause) {
        super(message, cause);
        this.addMessageErro(message);
    }

    public BaseException(Throwable cause) {
        super(cause);
        this.addMessageErro(cause.getMessage());
    }

    public BaseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.addMessageErro(message);
    }

    public void add(List<BaseException> lista) {
        this.listExceptions.addAll(lista);
    }

    public void add(BaseException ex) {
        this.listExceptions.add(ex);
    }

    public void add(String mensagem) {
        this.listExceptions.add(new Exception(mensagem));
    }

    public boolean hasException() {
        return !this.listExceptions.isEmpty();
    }

    public List<Exception> getListExceptions() {
        return Collections.unmodifiableList(this.listExceptions);
    }

    private void addMessageErro(String message) {
        try {
            GlobalInformation.getInstance().set("mensagemErroValidacao", (Serializable)((Object)message));
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return StringUtils.isNullOrEmpty((String)message) ? className : message;
    }
}

