/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.excel;

import br.com.jarch.util.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel {
    private final XSSFWorkbook workbook = new XSSFWorkbook();
    private XSSFSheet sheet;

    private Excel() {
    }

    public static Excel builder() {
        return new Excel();
    }

    public Excel createSheet(String name) {
        this.sheet = this.workbook.createSheet(name);
        int lastRow = this.sheet.getLastRowNum();
        if (lastRow < 0) {
            lastRow = 0;
        }
        this.sheet.createRow(lastRow);
        return this;
    }

    public Excel addLine() {
        if (this.sheet == null) {
            this.createSheet("");
        }
        this.sheet.createRow(this.sheet.getLastRowNum() + 1);
        return this;
    }

    public Excel addValueCell(Object value) {
        short lastCell = this.sheet.getRow(this.sheet.getLastRowNum()).getLastCellNum();
        lastCell = lastCell < 0 ? (short)0 : lastCell;
        XSSFCell cell = this.sheet.getRow(this.sheet.getLastRowNum()).createCell((int)lastCell);
        if (value == null) {
            cell.setCellValue("");
        } else if (value.getClass().isAssignableFrom(String.class)) {
            cell.setCellValue(String.valueOf(value));
        } else if (value.getClass().isAssignableFrom(Date.class)) {
            cell.setCellValue(new SimpleDateFormat("dd/MM/yyyy").format((Date)value));
        } else if (value.getClass().isAssignableFrom(YearMonth.class)) {
            cell.setCellValue(((YearMonth)value).format(DateTimeFormatter.ofPattern("MM/yyyy")));
        } else if (value.getClass().isAssignableFrom(LocalDate.class)) {
            cell.setCellValue(DateUtils.formatddMMyyyy((LocalDate)((LocalDate)value)));
        } else if (value.getClass().isAssignableFrom(LocalDateTime.class)) {
            cell.setCellValue(DateUtils.formatddMMyyyyHHmm((LocalDateTime)((LocalDateTime)value)));
        } else if (value.getClass().isAssignableFrom(Double.class)) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value.getClass().isAssignableFrom(BigDecimal.class)) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value.getClass().isAssignableFrom(BigInteger.class)) {
            cell.setCellValue((double)((BigInteger)value).intValue());
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            cell.setCellValue((double)Long.parseLong(String.valueOf(value)));
        } else if (value.getClass().isAssignableFrom(Boolean.class)) {
            cell.setCellValue((Boolean)value != false ? "Sim" : "N\u00e3o");
        } else if (Enum.class.isAssignableFrom(value.getClass())) {
            cell.setCellValue(String.valueOf(value));
        } else {
            cell.setCellValue(value.toString());
        }
        return this;
    }

    public Excel addValueCell(File file) {
        short lastCell = this.sheet.getRow(this.sheet.getLastRowNum()).getLastCellNum();
        lastCell = lastCell < 0 ? (short)0 : lastCell;
        try {
            XSSFCreationHelper helper = this.workbook.getCreationHelper();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setAnchorType(0);
            anchor.setRow1(this.sheet.getLastRowNum());
            anchor.setRow2(this.sheet.getLastRowNum() + 3);
            anchor.setCol1((int)lastCell);
            anchor.setCol2(lastCell + 1);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    public Excel mergiedRegion(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        this.sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn));
        return this;
    }

    public InputStream buildStream() throws IOException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        this.workbook.write((OutputStream)fos);
        return new ByteArrayInputStream(fos.toByteArray());
    }

    public File buildFile() throws IOException {
        return this.buildFile("PlanilhaExcel");
    }

    public File buildFile(String prefixName) throws IOException {
        File file = File.createTempFile(prefixName, ".xlsx");
        FileOutputStream fos = new FileOutputStream(file);
        this.workbook.write((OutputStream)fos);
        return file;
    }

    public void build(OutputStream ops) throws IOException {
        this.workbook.write(ops);
    }
}

