/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.crud.dynamic.FieldDynamicEntity;
import br.com.jarch.core.crud.dynamic.FieldDynamicJpqlBuilder;
import br.com.jarch.core.crud.dynamic.IDynamicColumn;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.type.ConditionSearchType;
import java.math.BigDecimal;
import java.util.Map;

final class DynamicFieldSearchFactory
extends BaseFieldSearchFactory {
    DynamicFieldSearchFactory() {
    }

    void createFieldSearch(Class<?> classEntity, Map<String, FieldSearch> mapFieldSearch) {
        if (!IDynamicColumn.class.isAssignableFrom(classEntity)) {
            return;
        }
        FieldDynamicJpqlBuilder.newInstance().orderBy(FieldOrder.asc("row"), FieldOrder.asc("column")).where().equalsTo("nameEntity", (Object)classEntity.getSimpleName()).and().equalsTo("search", (Object)true).collect().list().forEach(fieldDynamic -> this.addFieldSearch(classEntity, (FieldDynamicEntity)fieldDynamic, mapFieldSearch));
    }

    private void addFieldSearch(Class<?> classEntity, FieldDynamicEntity fieldDynamic, Map<String, FieldSearch> mapFieldSearch) {
        String atributo = "dynamicColumn['" + fieldDynamic.getColumnName() + "']";
        String descricao = fieldDynamic.getLabel();
        String id = this.createId(classEntity, fieldDynamic.getColumnName(), atributo, mapFieldSearch);
        Class attributeType = fieldDynamic.isDecimals() ? BigDecimal.class : String.class;
        ConditionSearchType condition = ConditionSearchType.EQUAL;
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchField.class).id(id).mask("").clearValueByButton(true).classAttribute(attributeType).type(fieldDynamic.getType()).attribute(atributo).description(descricao).condition(condition).visibleCondition(true).disabledCondition(false).row(fieldDynamic.getRowSearch()).column(fieldDynamic.getColumnSearch()).span(fieldDynamic.getSpanSearch()).where("").zeroLeft(false).quantityZeroLeft(0).hide(false).tooltip(fieldDynamic.getLabel()).tabName("label.main").tabOrder(0);
        mapFieldSearch.put(id, fieldSearch);
    }
}

