/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.rest;

import br.com.jarch.core.crud.entity.BaseEntity;
import br.com.jarch.core.crud.report.FileResultDto;
import br.com.jarch.core.crud.report.IReportList;
import br.com.jarch.core.crud.repository.CrudRepository;
import br.com.jarch.core.crud.search.IPaginator;
import br.com.jarch.core.crud.search.ISearch;
import br.com.jarch.core.crud.search.Paginator;
import br.com.jarch.core.crud.search.Search;
import br.com.jarch.core.crud.service.ICrudService;
import br.com.jarch.core.model.ColumnList;
import br.com.jarch.core.model.ColumnsList;
import br.com.jarch.core.model.IColumnList;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.ErrorUtils;
import br.com.jarch.util.ByteUtils;
import br.com.jarch.util.CharacterUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.persistence.NoResultException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class BaseRest<E extends ICrudEntity, S extends ICrudService<E>, R extends CrudRepository<E>, X extends ISearch<E>>
implements Serializable {
    @Inject
    private Instance<S> serviceInstance;
    @Inject
    private Instance<X> searchInstance;
    @Inject
    private Instance<R> repositoryInstance;
    @Inject
    private IReportList reportList;

    public S getService() {
        return (S)((ICrudService)this.serviceInstance.get());
    }

    public R getRepository() {
        return (R)((CrudRepository)this.repositoryInstance.get());
    }

    private X getSearch() {
        return (X)((ISearch)this.searchInstance.get());
    }

    @ApiOperation(value="Object Search", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get object Search", response=Search.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="object/search")
    public Response objectSearch() {
        return Response.ok().entity(this.getSearch()).build();
    }

    @ApiOperation(value="Object ColumnList", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get object ColumnList", response=ColumnList.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="object/columnList")
    public Response objectColumnList() {
        List columnsList = ColumnsList.create(this.getService().getClassEntity()).stream().filter(IColumnList::isVisible).collect(Collectors.toList());
        return Response.ok().entity(columnsList).build();
    }

    @ApiOperation(value="Object AccessMenu", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get object AccessMenu", response=ColumnList.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="object/accessMenu")
    public Response objectAcessMenu() {
        return Response.ok().build();
    }

    @ApiOperation(value="Search", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get Paginator", response=Paginator.class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="search")
    public Response search(@ApiParam(value="Search", name="search", required=true) X search) {
        IPaginator paginator = this.getRepository().searchAllWithPaginatorBy(search);
        return Response.ok().entity(paginator).build();
    }

    @ApiOperation(value="Search", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get Entity by ID", response=BaseEntity.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="search/{id}")
    public Response loadEntity(@ApiParam(value="ID", name="id", required=true) @PathParam(value="id") String id) {
        return Response.ok().entity(this.getService().loadCrud(Long.valueOf(id))).build();
    }

    @ApiOperation(value="Lookup", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get Entity by Code Lookup", response=BaseEntity.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="lookup/{field}/{value}")
    public Response lookupCode(@ApiParam(value="Code", name="code", required=true) @PathParam(value="field") String fieldCode, @ApiParam(value="Value", name="value", required=true) @PathParam(value="value") String valueCode) {
        return Response.ok().entity(this.getRepository().searchOneBy(fieldCode, valueCode)).build();
    }

    @ApiOperation(value="Entity", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Get Entity empty", response=BaseEntity.class), @ApiResponse(code=500, message="Error")})
    @GET
    @Produces(value={"application/json"})
    @Path(value="object/entity")
    public Response objectEntity() {
        return Response.ok().entity(this.getService().createEntity()).build();
    }

    @ApiOperation(value="Insert Entity", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Insert Entity", response=void.class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response insert(@ApiParam(value="Entity", name="entity", required=true) E entity) {
        try {
            this.getService().insert(entity);
            return Response.ok().build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="Change Entity", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Change Entity", response=void.class), @ApiResponse(code=500, message="Error")})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response change(@ApiParam(value="Entity", name="entity", required=true) E entity) {
        try {
            this.getService().change(entity);
            return Response.ok().build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="Delete Entity", consumes="application/json", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Delete Entity", response=void.class), @ApiResponse(code=500, message="Error")})
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public Response delete(@ApiParam(value="Entity", name="entity", required=true) @PathParam(value="id") String id) {
        try {
            this.getService().delete(Long.valueOf(id));
            return Response.ok().build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="PDF", consumes="application/json", produces="application/pdf")
    @ApiResponses(value={@ApiResponse(code=200, message="Get PDF", response=Byte[].class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/pdf"})
    @Path(value="pdf")
    public Response pdf(@ApiParam(value="Search", name="search", required=true) X search) {
        try {
            Collection entitys = this.getRepository().searchAllBy(search);
            ColumnsList columnsList = ColumnsList.create(search.getClassEntity());
            columnsList.removeIf(c -> !c.isVisible());
            FileResultDto fileResult = this.reportList.exportFormatPdf((ISearch<?>)search, entitys, columnsList, (Collection<Map<String, String>>)Collections.emptyList(), (Collection<Map<String, String>>)Collections.emptyList(), null, false, this.getLabelReport());
            byte[] aByte = ByteUtils.toByteArray((InputStream)fileResult.getInputStream());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)aByte).build();
        }
        catch (BadRequestException | NumberFormatException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        catch (NoResultException ex) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ex.getMessage()).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="Excel", consumes="application/json", produces="application/vnd.ms-excel")
    @ApiResponses(value={@ApiResponse(code=200, message="Get PDF", response=Byte[].class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="excel")
    public Response excel(@ApiParam(value="Search", name="search", required=true) X search) {
        try {
            Collection entitys = this.getRepository().searchAllBy(search);
            ColumnsList columnsList = ColumnsList.create(search.getClassEntity());
            columnsList.removeIf(c -> !c.isVisible());
            FileResultDto fileResult = this.reportList.exportFormatExcel(entitys, columnsList, this.getLabelReport());
            byte[] aByte = ByteUtils.toByteArray((InputStream)fileResult.getInputStream());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)aByte).build();
        }
        catch (BadRequestException | NumberFormatException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        catch (NoResultException ex) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ex.getMessage()).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="CSV", consumes="application/json", produces="text/csv")
    @ApiResponses(value={@ApiResponse(code=200, message="Get PDF", response=Byte[].class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv"})
    @Path(value="csv")
    public Response csv(@ApiParam(value="Search", name="search", required=true) X search) {
        try {
            Collection entitys = this.getRepository().searchAllBy(search);
            ColumnsList columnsList = ColumnsList.create(search.getClassEntity());
            columnsList.removeIf(c -> !c.isVisible());
            FileResultDto fileResult = this.reportList.exportFormatCsv(entitys, columnsList, this.getLabelReport());
            byte[] aByte = ByteUtils.toByteArray((InputStream)fileResult.getInputStream());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)aByte).build();
        }
        catch (BadRequestException | NumberFormatException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        catch (NoResultException ex) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ex.getMessage()).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="CSV", consumes="application/json", produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Get PDF", response=Byte[].class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Path(value="txt")
    public Response txt(@ApiParam(value="Search", name="search", required=true) X search) {
        try {
            Collection entitys = this.getRepository().searchAllBy(search);
            ColumnsList columnsList = ColumnsList.create(search.getClassEntity());
            columnsList.removeIf(c -> !c.isVisible());
            FileResultDto fileResult = this.reportList.exportFormatTxt((ISearch<?>)search, entitys, columnsList, (Collection<Map<String, String>>)Collections.emptyList(), (Collection<Map<String, String>>)Collections.emptyList(), null, false, this.getLabelReport());
            byte[] aByte = ByteUtils.toByteArray((InputStream)fileResult.getInputStream());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)aByte).build();
        }
        catch (BadRequestException | NumberFormatException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        catch (NoResultException ex) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ex.getMessage()).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    @ApiOperation(value="XML", consumes="application/json", produces="application/xml")
    @ApiResponses(value={@ApiResponse(code=200, message="Get PDF", response=Byte[].class), @ApiResponse(code=500, message="Error")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    @Path(value="xml")
    public Response xml(@ApiParam(value="Search", name="search", required=true) X search) {
        try {
            Collection entitys = this.getRepository().searchAllBy(search);
            ColumnsList columnsList = ColumnsList.create(search.getClassEntity());
            columnsList.removeIf(c -> !c.isVisible());
            FileResultDto fileResult = this.reportList.exportFormatXml(entitys, columnsList, this.getLabelReport());
            byte[] aByte = ByteUtils.toByteArray((InputStream)fileResult.getInputStream());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)aByte).build();
        }
        catch (BadRequestException | NumberFormatException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build();
        }
        catch (NoResultException ex) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)ex.getMessage()).build();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Response.serverError().entity(ErrorUtils.messagesErro(ex)).build();
        }
    }

    private String getLabelReport() {
        Class classEntity = this.getService().getClassEntity();
        String nameClass = CharacterUtils.firstCaracterLowerCase((String)classEntity.getSimpleName()).replace("Entity", "");
        return "label." + nameClass;
    }
}

