/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.dynamic;

import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import br.com.jarch.core.model.IFieldType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.NumberUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.hibernate.envers.Audited;

@Audited
@Table(name="tb_dynamicfield", indexes={@Index(columnList="nm_page", name="dx_dynamicfieldnmpag"), @Index(columnList="nm_label", name="dx_dynamicfieldnmlab"), @Index(columnList="tp_field", name="dx_dynamicfieldtpfie")})
@Entity(name="fieldDynamic")
@SequenceGenerator(name="FieldDynamicIdSequence", sequenceName="sq_iddynamicfield", allocationSize=1)
public class FieldDynamicEntity
extends CrudMultiTenantEntity
implements IFieldType {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="FieldDynamicIdSequence")
    @Column(name="id_dynamicfield")
    private Long id;
    @Column(name="nm_page", nullable=false, length=500)
    @JArchValidRequired(value="label.page")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String page;
    @Column(name="nm_entity", nullable=false, length=100)
    @JArchValidRequired(value="label.nameEntity")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String nameEntity;
    @Column(name="nm_table", nullable=false, length=100)
    @JArchValidRequired(value="label.nameTable")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String nameTable;
    @Column(name="nm_label", nullable=false, length=50)
    @JArchValidRequired(value="label.label")
    @Size(max=50, message="{message.maxSizeExceeded}")
    private @Size(max=50, message="{message.maxSizeExceeded}") String label;
    @Column(name="nm_column", nullable=false, length=50)
    @JArchValidRequired(value="label.column")
    @Size(max=50, message="{message.maxSizeExceeded}")
    private @Size(max=50, message="{message.maxSizeExceeded}") String columnName;
    @Column(name="tp_field", nullable=false, length=50)
    @JArchValidRequired(value="label.field")
    @Enumerated(value=EnumType.STRING)
    private FieldType field;
    @Column(name="sn_valuerequired", nullable=false, length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    @JArchValidRequired(value="label.required")
    private Boolean valueRequired;
    @Column(name="sq_row", nullable=false)
    @JArchValidRequired(value="label.row")
    private Integer row;
    @Column(name="sq_column", nullable=false)
    @JArchValidRequired(value="label.column")
    private Integer column;
    @Column(name="sn_datatable", nullable=false, length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    @JArchValidRequired(value="label.dataTable")
    private Boolean datatable;
    @Column(name="sq_columndatatable", nullable=false)
    @JArchValidRequired(value="label.columnDatatable")
    private Integer columnDatatable;
    @Column(name="sn_search", nullable=false, length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    @JArchValidRequired(value="label.search")
    private Boolean search;
    @Column(name="sq_rowsearch", nullable=false)
    @JArchValidRequired(value="label.rowSearch")
    private Integer rowSearch;
    @Column(name="sq_columnsearch", nullable=false)
    @JArchValidRequired(value="label.columnSearch")
    private Integer columnSearch;
    @Column(name="qt_spansearch", nullable=false)
    @JArchValidRequired(value="label.spanSearch")
    private Integer spanSearch;
    @Transient
    private transient String value;
    @Transient
    private transient byte[] valueBinary;

    public FieldDynamicEntity() {
    }

    public FieldDynamicEntity(Long id, String page, String label, FieldType field, Boolean valueRequired) {
        this.id = id;
        this.page = page;
        this.label = label;
        this.field = field;
        this.valueRequired = valueRequired;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getNameEntity() {
        return this.nameEntity;
    }

    public void setNameEntity(String nameEntity) {
        this.nameEntity = nameEntity;
    }

    public String getNameTable() {
        return this.nameTable;
    }

    public void setNameTable(String nameTable) {
        this.nameTable = nameTable;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.ajustsColumnName();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public FieldType getField() {
        return this.field;
    }

    public void setField(FieldType field) {
        this.field = field;
    }

    public Boolean getValueRequired() {
        return this.valueRequired;
    }

    public void setValueRequired(Boolean required) {
        this.valueRequired = required;
    }

    public Integer getRow() {
        return this.row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getDatatable() {
        return this.datatable;
    }

    public void setDatatable(Boolean datatable) {
        this.datatable = datatable;
    }

    public Integer getColumnDatatable() {
        return this.columnDatatable;
    }

    public void setColumnDatatable(Integer columnDatatable) {
        this.columnDatatable = columnDatatable;
    }

    public Boolean getSearch() {
        return this.search;
    }

    public void setSearch(Boolean search) {
        this.search = search;
    }

    public Integer getRowSearch() {
        return this.rowSearch;
    }

    public void setRowSearch(Integer rowSearch) {
        this.rowSearch = rowSearch;
    }

    public Integer getColumnSearch() {
        return this.columnSearch;
    }

    public void setColumnSearch(Integer columnSearch) {
        this.columnSearch = columnSearch;
    }

    public Integer getSpanSearch() {
        return this.spanSearch;
    }

    public void setSpanSearch(Integer spanSearch) {
        this.spanSearch = spanSearch;
    }

    public Collection<FieldType> getFields() {
        return FieldType.getCollection().stream().filter(f -> !f.isAddress()).filter(f -> !f.isEntity()).filter(f -> !f.isEnum()).filter(f -> !f.isGeneric()).sorted(Comparator.comparing(FieldType::getAttribute)).collect(Collectors.toList());
    }

    public String getFieldDescription() {
        return this.field == null ? "" : this.field.getDescription();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.valueRequired != null && this.valueRequired != false;
    }

    @Override
    public FieldType getType() {
        return this.field;
    }

    @Override
    public String getMask() {
        return IFieldType.super.getMask();
    }

    @Override
    public boolean isCep() {
        return FieldType.CEP.equals((Object)this.getType());
    }

    @Override
    public boolean isChips() {
        return FieldType.CHIPS.equals((Object)this.getType());
    }

    @Override
    public boolean isCnpj() {
        return FieldType.CNPJ.equals((Object)this.getType());
    }

    @Override
    public boolean isCnpjBase() {
        return FieldType.CNPJ_BASE.equals((Object)this.getType());
    }

    @Override
    public boolean isCpfCnpj() {
        return FieldType.CPFCNPJ.equals((Object)this.getType());
    }

    @Override
    public boolean isCode() {
        return FieldType.CODE.equals((Object)this.getType());
    }

    @Override
    public boolean isMonthYear() {
        return FieldType.MONTH_YEAR.equals((Object)this.getType());
    }

    @Override
    public boolean isCpf() {
        return FieldType.CPF.equals((Object)this.getType());
    }

    @Override
    public boolean isDate() {
        return FieldType.DATE.equals((Object)this.getType());
    }

    @Override
    public boolean isDateTime() {
        return FieldType.DATE_TIME.equals((Object)this.getType());
    }

    @Override
    public boolean isLocalDate() {
        return false;
    }

    @Override
    public boolean isLocalDateTime() {
        return false;
    }

    @Override
    public boolean isDescriptionNameGeneric() {
        return IFieldType.super.isDescriptionNameGeneric();
    }

    @Override
    public boolean isDescriptionNameGenericSmall() {
        return IFieldType.super.isDescriptionNameGenericSmall();
    }

    @Override
    public boolean isPassword() {
        return FieldType.PASSWORD.equals((Object)this.getType());
    }

    @Override
    public boolean isEmail() {
        return FieldType.EMAIL.equals((Object)this.getType());
    }

    @Override
    public boolean isHour() {
        return FieldType.HOUR.equals((Object)this.getType());
    }

    @Override
    public boolean isIm() {
        return FieldType.IM.equals((Object)this.getType());
    }

    @Override
    public boolean isMemoRich() {
        return FieldType.MEMO_RICH.equals((Object)this.getType());
    }

    @Override
    public boolean isMemoSimple() {
        return FieldType.MEMO_SIMPLE.equals((Object)this.getType());
    }

    @Override
    public boolean isM2() {
        return FieldType.M2.equals((Object)this.getType());
    }

    @Override
    public boolean isNumber() {
        return IFieldType.super.isNumber();
    }

    @Override
    public boolean isMoney() {
        return FieldType.MONEY.equals((Object)this.getType());
    }

    @Override
    public boolean isPercentage() {
        return FieldType.PERCENTAGE.equals((Object)this.getType());
    }

    @Override
    public boolean isRate() {
        return FieldType.RATE.equals((Object)this.getType());
    }

    @Override
    public boolean isDecimals() {
        return IFieldType.super.isDecimals();
    }

    @Override
    public boolean isRg() {
        return FieldType.RG.equals((Object)this.getType());
    }

    @Override
    public boolean isTelephone() {
        return IFieldType.super.isTelephone();
    }

    @Override
    public boolean isBoolean() {
        return FieldType.BOOLEAN.equals((Object)this.getType());
    }

    @Override
    public boolean isEntity() {
        return FieldType.ENTITY.equals((Object)this.getType());
    }

    @Override
    public boolean isBinary() {
        return FieldType.BINARY.equals((Object)this.getType());
    }

    @Override
    public boolean isEnumerated() {
        return FieldType.ENUMERATED.equals((Object)this.getType());
    }

    @Override
    public boolean isString() {
        return IFieldType.super.isString();
    }

    @Override
    public boolean isCurrency() {
        return IFieldType.super.isCurrency();
    }

    @Override
    public boolean isTime() {
        return IFieldType.super.isTime();
    }

    public void configLabelFromType() {
        if (this.field != null && (this.label == null || this.label.isBlank())) {
            this.label = this.field.getDescription();
            this.ajustsColumnName();
        }
    }

    public BigDecimal getValueBigDecimal() {
        if (this.value == null) {
            return null;
        }
        return new BigDecimal(this.value.replace(".", "").replace(",", "."));
    }

    public void setValueBigDecimal(BigDecimal valueBigDecimal) {
        this.value = NumberUtils.formatMoney((Number)valueBigDecimal);
    }

    public YearMonth getValueYearMonth() {
        if (this.value == null) {
            return null;
        }
        return YearMonth.parse(this.value, DateTimeFormatter.ofPattern("MM/yyyy"));
    }

    public void setValueYearMonth(YearMonth valueYearMonth) {
        this.value = valueYearMonth.format(DateTimeFormatter.ofPattern("MM/yyyy"));
    }

    public LocalDate getValueLocalDate() {
        if (this.value == null) {
            return null;
        }
        return LocalDate.parse(this.value, DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    public void setValueLocalDate(LocalDate valueLocalDate) {
        this.value = valueLocalDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    public LocalDateTime getValueLocalDateTime() {
        if (this.value == null) {
            return null;
        }
        return LocalDateTime.parse(this.value, DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
    }

    public void setValueLocalDateTime(LocalDateTime valueLocalDateTime) {
        this.value = valueLocalDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
    }

    public LocalTime getValueLocalTime() {
        if (this.value == null) {
            return null;
        }
        return LocalTime.parse(this.value, DateTimeFormatter.ofPattern("HH:mm"));
    }

    public void setValueLocalTime(LocalTime valueLocalTime) {
        this.value = valueLocalTime.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public byte[] getValueBinary() {
        return this.valueBinary;
    }

    public void setValueBinary(byte[] valueBinary) {
        this.valueBinary = valueBinary;
    }

    public Collection<String> getValueCollection() {
        if (this.value == null) {
            return null;
        }
        return Arrays.stream(this.value.split(",")).collect(Collectors.toList());
    }

    public void setValueCollection(Collection<String> valueCollection) {
        if (valueCollection == null) {
            this.value = null;
        }
        this.value = valueCollection.stream().collect(Collectors.joining(","));
    }

    private void ajustsColumnName() {
        String newColumnName;
        if (this.label == null) {
            return;
        }
        this.columnName = newColumnName = CharacterUtils.removeCharEspecial((String)this.label).replace("\\", "").replace("/", "").replace(".", "").replace(" ", "").replace("?", "");
    }
}

