/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.communication;

import br.com.jarch.core.crud.communication.Attach;
import br.com.jarch.core.crud.communication.Message;
import br.com.jarch.core.crud.communication.StyleType;
import java.io.File;
import java.time.LocalDate;
import java.util.Collection;

public final class MessageBuilder {
    private final Message message = new Message();

    private MessageBuilder() {
    }

    public static MessageBuilder newInstance() {
        return new MessageBuilder();
    }

    public MessageBuilder id(Long id) {
        this.message.setId(id);
        return this;
    }

    public MessageBuilder code(Long code) {
        this.message.setCode(code);
        return this;
    }

    public MessageBuilder type(Integer type) {
        this.message.setType(type);
        return this;
    }

    public MessageBuilder title(String title) {
        this.message.setTitle(title);
        return this;
    }

    public MessageBuilder description(String description) {
        this.message.setDescription(description);
        return this;
    }

    public MessageBuilder body(String body) {
        this.message.setBody(body);
        return this;
    }

    public MessageBuilder link(String link) {
        this.message.setLink(link);
        return this;
    }

    public MessageBuilder from(Long from) {
        this.message.setFrom(from);
        return this;
    }

    public MessageBuilder to(Long to) {
        this.message.setTo(to);
        return this;
    }

    public MessageBuilder allowsExclusion(boolean allowsExclusion) {
        this.message.setAllowsExclusion(allowsExclusion);
        return this;
    }

    public MessageBuilder expiration(LocalDate expiration) {
        this.message.setExpiration(expiration);
        return this;
    }

    public MessageBuilder attachs(Collection<Attach> attaches) {
        for (Attach attach : attaches) {
            this.message.getAttachs().add(attach);
        }
        return this;
    }

    public MessageBuilder attach(String fileName, byte[] binary) {
        this.message.getAttachs().add(new Attach(fileName, binary));
        return this;
    }

    public MessageBuilder attach(String fileName, File file) {
        this.message.getAttachs().add(new Attach(fileName, file));
        return this;
    }

    public MessageBuilder success() {
        this.message.setStyle(StyleType.SUCCESS);
        return this;
    }

    public MessageBuilder warning() {
        this.message.setStyle(StyleType.WARNING);
        return this;
    }

    public MessageBuilder danger() {
        this.message.setStyle(StyleType.DANGER);
        return this;
    }

    public Message build() {
        return this.message;
    }
}

