/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.type;

import br.com.jarch.apt.util.ProcessorUtils;

public enum CodeType {
    ENTITY("Entity", ".java"),
    REPOSITORY("Repository", ".java"),
    JPA_REPOSITORY("JpaRepository", ".java"),
    DATA_CONTROLLER("DataController", ".java"),
    DATA_DETAIL("DataDetail", ".java"),
    EMBEDDABLE("Embeddable", ".java"),
    OBSERVER("Observer", ".java"),
    FILTERSELECT_CONTROLLER("FilterSelectController", ".java"),
    JPA_CONVERTER("JpaConverter", ".java"),
    JPQL_BUILDER("JpqlBuilder", ".java"),
    LIST_CONTROLLER("ListController", ".java"),
    REST("Rest", ".java"),
    SEARCH("Search", ".java"),
    SERVICE("CrudService", ".java"),
    TYPE("Type", ".java"),
    PACKAGE_INFO("", ".java");

    private String suffixName;
    private String pathExtension;

    private CodeType(String suffixName, String pathExtension) {
        this.suffixName = suffixName;
        this.pathExtension = pathExtension;
    }

    public String getSuffixName() {
        return this.suffixName;
    }

    public String getPathExtension() {
        return this.pathExtension;
    }

    public String getName(String useCase) {
        return ProcessorUtils.getNameWithoutCharEspecialCapitalize(useCase) + this.suffixName;
    }

    public String getFullName(String namePackage, String useCase) {
        return namePackage.concat(".").concat(this.getName(useCase));
    }

    public String getVarName(String useCase) {
        return ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(useCase);
    }
}

