/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import javax.lang.model.element.Element;

public class TypeCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, String useCase, String nameSubPackage) {
        new TypeCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    TypeCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.TYPE;
    }

    @Override
    public String getContent() {
        StringBuilder sbListCode = new StringBuilder();
        this.addPackage(sbListCode);
        this.addImports(sbListCode);
        this.addBody(sbListCode);
        return sbListCode.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.util.BundleUtils;");
        ProcessorUtils.addCode(sbListCode, "import java.util.ArrayList;");
        ProcessorUtils.addCode(sbListCode, "import java.util.Arrays;");
        ProcessorUtils.addCode(sbListCode, "import java.util.Collection;");
        ProcessorUtils.addCode(sbListCode, "import java.util.stream.Collectors;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "public enum " + this.getName() + " {");
        ProcessorUtils.addCode(sbListCode, "\tSAMPLE1(\"SM1\", \"label.sample1\"),");
        ProcessorUtils.addCode(sbListCode, "\tSAMPLE2(\"SM2\", \"label.sample2\");");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tprivate final String abbreviation;");
        ProcessorUtils.addCode(sbListCode, "\tprivate final String description;");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\t" + this.getName() + "(String abbreviation, String description) {");
        ProcessorUtils.addCode(sbListCode, "\t\tthis.abbreviation = abbreviation;");
        ProcessorUtils.addCode(sbListCode, "\t\tthis.description = description;");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic String getAbbreviation() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn abbreviation;");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic String getDescription() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn BundleUtils.messageBundle(description);");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic static " + this.getName() + " abbreviationToEnum(String abbreviation){");
        ProcessorUtils.addCode(sbListCode, "\t\treturn Arrays.stream(values()).filter(m -> m.getAbbreviation().equals(abbreviation)).findAny().orElse(null);");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic static Collection<" + this.getName() + "> getCollection() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn Arrays.stream(values()).collect(Collectors.toCollection(ArrayList::new));");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

