/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class RestCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new RestCodeGenerate(element, generateCrud).generate();
    }

    RestCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        super(element, generateCrud);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.WS;
    }

    @Override
    public CodeType getType() {
        return CodeType.REST;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameEntity() + ";");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameService() + ";");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameRepository() + ";");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameSearch() + ";");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchRest;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.crud.rest.BaseRest;");
        ProcessorUtils.addCode(sbListCode, "import io.swagger.annotations.Api;");
        ProcessorUtils.addCode(sbListCode, "import jakarta.ws.rs.Path;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@Api");
        ProcessorUtils.addCode(sbListCode, "@Path(\"" + this.getVarName() + "\")");
        ProcessorUtils.addCode(sbListCode, "@JArchRest");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " extends BaseRest<" + this.getNameEntity() + ", " + this.getNameService() + ", " + this.getNameRepository() + ", " + this.getNameSearch() + "> {");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

