/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.core.form.SearchFieldForm;
import br.com.jarch.core.form.XhtmlFieldForm;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public final class PackageInfoCodeGenerate {
    private final Element element;
    private String nameSubPackage;
    private final JArchGenerateCrud generateCrud;
    private File filePackageInfo;
    private String namePackage;
    private boolean importArchSearchFieldCombobox;
    private boolean importArchSearchFieldLookup;
    private boolean importCondition;
    private final Set<String> imports = new HashSet<String>();

    PackageInfoCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        this.element = element;
        this.generateCrud = generateCrud;
        this.configure(element, generateCrud.nameSubPackage());
    }

    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new PackageInfoCodeGenerate(element, generateCrud).generate();
    }

    private void generate() {
        if (ProcessorUtils.isFileExistsClientOrWebOrWs(this.filePackageInfo)) {
            return;
        }
        StringBuilder sbPackageInfo = new StringBuilder();
        ProcessorUtils.addCode(sbPackageInfo, this.searchFields(this.generateCrud.master().name(), ProcessorUtils.getListFieldForm(this.generateCrud.master().fields())));
        ProcessorUtils.addCode(sbPackageInfo, this.columnsDataTable(this.generateCrud.master().name(), ProcessorUtils.getListFieldForm(this.generateCrud.master().fields())));
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> {
            ProcessorUtils.addCode(sbPackageInfo, this.searchFields(detail.name(), ProcessorUtils.getListFieldForm(detail.fields())));
            ProcessorUtils.addCode(sbPackageInfo, this.columnsDataTable(detail.name(), ProcessorUtils.getListFieldForm(detail.fields())));
            Arrays.stream(detail.subDetails()).forEach(subDetail -> {
                ProcessorUtils.addCode(sbPackageInfo, this.searchFields(subDetail.name(), ProcessorUtils.getListFieldForm(subDetail.fields())));
                ProcessorUtils.addCode(sbPackageInfo, this.columnsDataTable(subDetail.name(), ProcessorUtils.getListFieldForm(subDetail.fields())));
            });
        });
        ProcessorUtils.addLineBlank(sbPackageInfo);
        ProcessorUtils.addCode(sbPackageInfo, "package " + this.namePackage + ";");
        ProcessorUtils.addLineBlank(sbPackageInfo);
        ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchColumnDataTable;");
        ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchColumnsDataTable;");
        ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.type.FieldType;");
        ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchSearchField;");
        if (this.importArchSearchFieldCombobox) {
            ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchSearchFieldCombobox;");
        }
        if (this.importArchSearchFieldLookup) {
            ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchSearchFieldLookup;");
        }
        if (this.importCondition) {
            ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.type.ConditionSearchType;");
        }
        ProcessorUtils.addCode(sbPackageInfo, "import br.com.jarch.core.annotation.JArchSearchTab;");
        this.imports.forEach(i -> ProcessorUtils.addCode(sbPackageInfo, i));
        try {
            FileUtils.save((File)this.filePackageInfo, (String)sbPackageInfo.toString().replace("\n\n", "\n"));
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.filePackageInfo.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    private String searchFields(String name, List<FieldForm> fieldForms) {
        String nameEntity = ProcessorUtils.getNomeEntity(name);
        StringBuilder searchFields = new StringBuilder();
        StringBuilder searchComboFields = new StringBuilder();
        StringBuilder searchLookFields = new StringBuilder();
        for (FieldForm campoForm : new ArrayList<FieldForm>(fieldForms)) {
            for (SearchFieldForm search : campoForm.getSearch().stream().sorted(Comparator.comparing(SearchFieldForm::getRow).thenComparing(SearchFieldForm::getColumn)).collect(Collectors.toList())) {
                this.imports.add("import " + this.namePackage.replace(".web.", ".client.") + "." + nameEntity + ";");
                if (campoForm.getTipo().isEnum()) {
                    this.importArchSearchFieldCombobox = true;
                    searchComboFields.append("\t\t@JArchSearchFieldCombobox(field = \"" + campoForm.getAtributo() + "\", label = \"" + campoForm.getBundleCodigoJava() + "\", fieldItems = \"" + campoForm.getAtributo() + "s\", fieldShow = \"description\", row = " + search.getRow() + ", column = " + search.getColumn() + ", span = " + (search.getSpan() == 0 ? campoForm.getTipo().getSpan().intValue() : search.getSpan()) + "), \n");
                    continue;
                }
                if (campoForm.getTipo().isEntity()) {
                    this.importArchSearchFieldLookup = true;
                    String entityLookup = campoForm.getAtributoPrimeiroLetraMaiusculo();
                    searchLookFields.append("\t\t@JArchSearchFieldLookup(field = \"" + campoForm.getAtributo() + "\", label = \"" + campoForm.getBundleCodigoJava() + "\", classEntityLookup = " + entityLookup + "Entity.class, row = " + search.getRow() + ", column = " + search.getColumn() + ", span = " + (search.getSpan() == 0 ? campoForm.getTipo().getSpan().intValue() : search.getSpan()) + "), \n");
                    this.imports.add("import " + this.namePackage.replace(this.nameSubPackage.toLowerCase(), entityLookup.toLowerCase()) + "." + entityLookup + "Entity;");
                    continue;
                }
                int quantityFieldsBeetwen = campoForm.getTipo().isNumber() || campoForm.getTipo().isDateTime() ? 2 : 1;
                for (int fieldActual = 0; fieldActual < quantityFieldsBeetwen; ++fieldActual) {
                    boolean first = fieldActual == 0;
                    String condition = "";
                    if (quantityFieldsBeetwen > 1) {
                        if (!campoForm.getSearch().isEmpty() && first) {
                            condition = "condition = ConditionSearchType.LARGER_EQUAL, ";
                        } else if (!campoForm.getSearch().isEmpty() && !first) {
                            condition = "condition = ConditionSearchType.LESS_EQUAL, ";
                        }
                    }
                    if (!condition.isEmpty()) {
                        this.importCondition = true;
                    }
                    searchFields.append("\t\t@JArchSearchField(field = \"" + campoForm.getAtributo() + "\", label = \"" + campoForm.getBundleCodigoJava() + "\", type = FieldType." + String.valueOf(campoForm.getTipo()) + ", " + condition + "row = " + search.getRow() + ", column = " + (search.getColumn() + fieldActual) + ", span = " + (search.getSpan() == 0 ? campoForm.getTipo().getSpan().intValue() : search.getSpan()) + "), \n");
                }
            }
        }
        Object sectionFieldsSearchs = String.format("//##################################################################################################################\n//### %s - Configuration of search fields and result fields\n//##################################################################################################################", nameEntity);
        sectionFieldsSearchs = (String)sectionFieldsSearchs + "\n@JArchSearchTab(order = 1, classEntity = " + nameEntity + ".class";
        if (!searchFields.toString().isEmpty()) {
            sectionFieldsSearchs = (String)sectionFieldsSearchs + ",\n\tsearchFields = {\n" + String.valueOf(searchFields) + "\t}";
        }
        if (!searchComboFields.toString().isEmpty()) {
            sectionFieldsSearchs = (String)sectionFieldsSearchs + ",\n\tsearchFieldComboboxes = {\n" + String.valueOf(searchComboFields) + "\t}";
        }
        if (!searchLookFields.toString().isEmpty()) {
            sectionFieldsSearchs = (String)sectionFieldsSearchs + ",\n\tsearchFieldLookups = {\n" + String.valueOf(searchLookFields) + "\t}";
        }
        sectionFieldsSearchs = (String)sectionFieldsSearchs + ")";
        return sectionFieldsSearchs;
    }

    private String columnsDataTable(String name, List<FieldForm> fieldForms) {
        String nameEntity = ProcessorUtils.getNomeEntity(name);
        StringBuilder result = new StringBuilder("@JArchColumnsDataTable(classEntity = " + nameEntity + ".class");
        boolean hasFieldColumn = false;
        for (FieldForm campoForm : fieldForms) {
            for (XhtmlFieldForm xhtml : campoForm.getXhtml()) {
                if (!xhtml.isShowDataTableList()) continue;
                String nomeAtributo = campoForm.getAtributo();
                if (!result.toString().contains("JArchColumnDataTable(field")) {
                    result.append(",\n\tcolumns = {\n");
                }
                result.append("\t\t@JArchColumnDataTable(field =\"" + nomeAtributo + (campoForm.getTipo().isEnum() ? ".description" : "") + "\", title = \"" + campoForm.getBundleCodigoJava() + "\", width = " + (xhtml.getWidth() == 0 ? campoForm.getTipo().getWidthXhtml().intValue() : xhtml.getWidth()) + ", type = FieldType." + campoForm.getTipo().name().replace("ENTITY", "NAME") + "),\n");
                hasFieldColumn = true;
            }
        }
        if (result.toString().contains("JArchColumnDataTable(field")) {
            result.append("\t}");
        }
        result.append(")");
        if (hasFieldColumn) {
            return result.toString();
        }
        return "";
    }

    private void configure(Element element, String nameSubPackage) {
        this.namePackage = ModuleType.WEB.getNamePackage(element, nameSubPackage);
        this.nameSubPackage = nameSubPackage;
        File folder = ModuleType.WEB.getFolder(element, nameSubPackage);
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.filePackageInfo = new File(folder.getAbsolutePath() + File.separator + "package-info.java");
    }
}

