/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class PipedZipBufferFactory {
    public static DeflatingPipedBuffer createDeflatingBuffer(int compressedDataSize) {
        return PipedZipBufferFactory.createDeflatingBuffer(compressedDataSize, -1);
    }

    public static DeflatingPipedBuffer createDeflatingBuffer(int compressedDataSize, int compressionLevel) {
        return new DeflatingPipedBufferImpl(compressedDataSize, compressionLevel);
    }

    public static InflatingPipedBuffer createInflatingBuffer(int compressedDataSize) {
        return new InflatingPipedBufferImpl(compressedDataSize);
    }

    private static abstract class PipedZipBufferSupport
    implements PipedZipBufferCommons {
        protected ByteBuffer compressedBuffer;
        protected ByteBuffer uncompressedBuffer;
        protected InputStream inputStream;
        protected OutputStream outputStream;

        private PipedZipBufferSupport(int compressedDataSize) {
            this.compressedBuffer = ByteBuffer.allocate(compressedDataSize);
            this.uncompressedBuffer = ByteBuffer.allocate(compressedDataSize * 10);
            this.outputStream = IOUtil.newOutputStream(this.getInputBuffer());
            this.inputStream = IOUtil.newInputStream(this.getOutputBuffer());
        }

        public final OutputStream getOutputStream() {
            return this.outputStream;
        }

        public final InputStream getInputStream() {
            return this.inputStream;
        }

        public void reset() {
            this.uncompressedBuffer.clear();
            this.compressedBuffer.clear();
        }

        public void destroy() {
            IOUtil.closeResource(this.inputStream);
            IOUtil.closeResource(this.outputStream);
            this.compressedBuffer = null;
            this.uncompressedBuffer = null;
            this.inputStream = null;
            this.outputStream = null;
        }
    }

    private static class InflatingPipedBufferImpl
    extends PipedZipBufferSupport
    implements InflatingPipedBuffer {
        private final Inflater inflater = new Inflater();
        private DataInputStream dataInput = new DataInputStream(this.getInputStream());

        private InflatingPipedBufferImpl(int compressedDataSize) {
            super(compressedDataSize);
        }

        public int inflate() throws DataFormatException {
            return this.inflate(this.compressedBuffer.capacity());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int inflate(int length) throws DataFormatException {
            try {
                this.inflater.setInput(this.compressedBuffer.array(), 0, length);
                int count = this.inflater.inflate(this.uncompressedBuffer.array());
                this.uncompressedBuffer.limit(count);
                this.uncompressedBuffer.position(0);
                int n = count;
                Object var5_4 = null;
                this.inflater.reset();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.inflater.reset();
                throw throwable;
            }
        }

        public void reset() {
            this.inflater.reset();
            super.reset();
        }

        public ByteBuffer getInputBuffer() {
            return this.compressedBuffer;
        }

        public ByteBuffer getOutputBuffer() {
            return this.uncompressedBuffer;
        }

        public DataInput getDataInput() {
            return this.dataInput;
        }

        public void destroy() {
            IOUtil.closeResource(this.dataInput);
            this.dataInput = null;
            this.inflater.end();
            super.destroy();
        }
    }

    private static class DeflatingPipedBufferImpl
    extends PipedZipBufferSupport
    implements DeflatingPipedBuffer {
        private final Deflater deflater;
        private DataOutputStream dataOutput;

        private DeflatingPipedBufferImpl(int compressedDataSize, int compressionLevel) {
            super(compressedDataSize);
            this.deflater = new Deflater(compressionLevel);
            this.dataOutput = new DataOutputStream(this.getOutputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int deflate() {
            try {
                int count;
                this.deflater.setInput(this.uncompressedBuffer.array(), 0, this.uncompressedBuffer.position());
                this.deflater.finish();
                int n = count = this.deflater.deflate(this.compressedBuffer.array());
                Object var4_3 = null;
                this.deflater.reset();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.deflater.reset();
                throw throwable;
            }
        }

        public void reset() {
            super.reset();
            this.deflater.reset();
        }

        public ByteBuffer getInputBuffer() {
            return this.uncompressedBuffer;
        }

        public ByteBuffer getOutputBuffer() {
            return this.compressedBuffer;
        }

        public DataOutput getDataOutput() {
            return this.dataOutput;
        }

        public void destroy() {
            IOUtil.closeResource(this.dataOutput);
            this.dataOutput = null;
            this.deflater.end();
            super.destroy();
        }
    }

    private static interface PipedZipBufferCommons {
        public ByteBuffer getInputBuffer();

        public ByteBuffer getOutputBuffer();

        public OutputStream getOutputStream();

        public InputStream getInputStream();

        public void reset();

        public void destroy();
    }

    public static interface InflatingPipedBuffer
    extends PipedZipBufferCommons {
        public DataInput getDataInput();

        public int inflate() throws DataFormatException;

        public int inflate(int var1) throws DataFormatException;
    }

    public static interface DeflatingPipedBuffer
    extends PipedZipBufferCommons {
        public DataOutput getDataOutput();

        public int deflate();
    }
}

