/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.fx.view.BaseFxml;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.animation.FadeTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;

@Singleton
public class MenuPrincipalController
extends BaseFxml {
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox sideMenu;
    @FXML
    private Label titleLabel;
    private static final double SIDEBAR_EXPANDED_WIDTH = 220.0;
    private static final double SIDEBAR_COLLAPSED_WIDTH = 60.0;
    private static final double SMALL_SCREEN_THRESHOLD = 800.0;
    private boolean sidebarExpanded = true;
    private boolean isSmallScreen = false;
    private ChangeListener<Number> stageWidthListener;
    private Button currentActiveButton;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.configuraTitulo();
        this.configuraMenus();
        this.setupResponsiveMenu();
        this.buttonHomeAction(null);
        Platform.runLater(() -> {
            Stage stageAtual = (Stage)this.rootPane.getScene().getWindow();
            stageAtual.setOnShown(event -> {
                this.onShowMenu();
                FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)0.8), (Node)this.rootPane);
                fadeIn.setFromValue(0.0);
                fadeIn.setToValue(1.0);
                fadeIn.setCycleCount(1);
                fadeIn.play();
                this.setupStageWidthListener(stageAtual);
            });
        });
    }

    private void setupResponsiveMenu() {
        this.storeButtonTexts();
    }

    private void storeButtonTexts() {
        this.sideMenu.getChildren().stream().filter(node -> node instanceof Button).forEach(node -> {
            Button button = (Button)node;
            if (button.getText() != null && !button.getText().isEmpty()) {
                button.setUserData((Object)button.getText());
            }
        });
    }

    private void setupStageWidthListener(Stage stage) {
        this.stageWidthListener = (observable, oldValue, newValue) -> {
            double width = newValue.doubleValue();
            boolean wasSmallScreen = this.isSmallScreen;
            boolean bl = this.isSmallScreen = width < 800.0;
            if (wasSmallScreen != this.isSmallScreen && this.isSmallScreen && this.sidebarExpanded) {
                this.sidebarExpanded = false;
                this.updateSidebarState();
            }
        };
        stage.widthProperty().addListener(this.stageWidthListener);
        double initialWidth = stage.getWidth();
        boolean bl = this.isSmallScreen = initialWidth < 800.0;
        if (this.isSmallScreen) {
            this.sidebarExpanded = false;
            this.updateSidebarState();
        }
    }

    private void onShowMenu() {
        this.configuraMenus();
    }

    public void buttonHomeAction(ActionEvent event) {
        if (event != null) {
            Button clickedButton = (Button)event.getSource();
            this.setActiveButton(clickedButton);
        }
        this.loadContentView("HomeView.fxml");
    }

    private void configuraMenus() {
        boolean mostraPublicacao = this.getConfiguracaoSingleton().getLogin() != null && (this.getConfiguracaoSingleton().getLogin().endsWith(".araujo") || this.getConfiguracaoSingleton().getLogin().endsWith(".fink"));
    }

    private void configuraTitulo() {
    }

    public void buttonInicioDesenvolvimentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("InicioDesenvolvimentoView.fxml");
    }

    public void buttonDescarteDesenvolvimentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("DescarteDesenvolvimentoView.fxml");
    }

    public void buttonSalvaDesenvolvimentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("SalvamentoDesenvolvimentoView.fxml");
    }

    public void buttonFimDesenvolvimentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("FinalizacaoDesenvolvimentoView.fxml");
    }

    public void buttonCriaEmpacotamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("CriacaoEmpacotamentoView.fxml");
    }

    public void buttonInicioEmpacotamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("InicioEmpacotamentoView.fxml");
    }

    public void buttonFimEmpacotamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("FinalizacaoEmpacotamentoView.fxml");
    }

    public void buttonFechaEmpacotamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("FechamentoEmpacotamentoView.fxml");
    }

    public void buttonInicioVersionamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("InicioVersionamentoView.fxml");
    }

    public void buttonDescarteVersionamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("DescarteVersionamentoView.fxml");
    }

    public void buttonFinalizaVersionamentoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("FinalizacaoVersionamentoView.fxml");
    }

    public void buttonIniciaPublicacaoAction(ActionEvent event) {
        Button clickedButton = (Button)event.getSource();
        this.setActiveButton(clickedButton);
        this.loadContentView("PublicacaoView.fxml");
    }

    public void sairMinimizarClicked(MouseEvent mouseEvent) {
        this.encerrarMinimizar(mouseEvent);
    }

    private void setActiveButton(Button button) {
        if (this.currentActiveButton != null) {
            this.currentActiveButton.getStyleClass().remove((Object)"sidebar-button-active");
        }
        button.getStyleClass().add((Object)"sidebar-button-active");
        this.currentActiveButton = button;
    }

    private void loadContentView(String fxmlFile) {
        try {
            FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)0.3), (Node)this.anchorPane);
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            fadeOut.setOnFinished(e -> {
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/view/" + fxmlFile));
                    Parent content = (Parent)loader.load();
                    this.anchorPane.getChildren().clear();
                    this.anchorPane.getChildren().add((Object)content);
                    AnchorPane.setTopAnchor((Node)content, (Double)0.0);
                    AnchorPane.setRightAnchor((Node)content, (Double)0.0);
                    AnchorPane.setBottomAnchor((Node)content, (Double)0.0);
                    AnchorPane.setLeftAnchor((Node)content, (Double)0.0);
                    FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)0.3), (Node)this.anchorPane);
                    fadeIn.setFromValue(0.0);
                    fadeIn.setToValue(1.0);
                    fadeIn.play();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
            fadeOut.play();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @FXML
    public void toggleSidebar() {
        this.sidebarExpanded = !this.sidebarExpanded;
        this.updateSidebarState();
    }

    private void updateSidebarState() {
        double targetWidth = this.sidebarExpanded ? 220.0 : 60.0;
        TranslateTransition transition = new TranslateTransition(Duration.millis((double)250.0), (Node)this.sideMenu);
        if (this.sidebarExpanded) {
            this.sideMenu.setPrefWidth(targetWidth);
            transition.setFromX(-160.0);
            transition.setToX(0.0);
            this.titleLabel.setVisible(true);
            this.titleLabel.setManaged(true);
        } else {
            this.sideMenu.setPrefWidth(targetWidth);
            transition.setFromX(0.0);
            transition.setToX(-160.0);
            this.titleLabel.setVisible(false);
            this.titleLabel.setManaged(false);
        }
        this.updateButtonsForSidebarState();
        transition.play();
    }

    private void updateButtonsForSidebarState() {
        this.sideMenu.getChildren().stream().filter(node -> node instanceof Button).map(node -> (Button)node).forEach(button -> {
            if (!this.sidebarExpanded) {
                button.setText("");
                button.setAlignment(Pos.CENTER);
            } else {
                if (button.getUserData() != null) {
                    button.setText(button.getUserData().toString());
                }
                button.setAlignment(Pos.BASELINE_LEFT);
            }
        });
    }
}

