/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.client.util.Utils;
import br.com.dsfnet.gpd.fx.util.AmbienteUtils;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.svn.SvnFachada;
import br.com.jarch.svn.SvnUtils;
import br.com.jarch.util.BashUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

@Singleton
public class InicioDesenvolvimentoController
extends BaseFxml {
    @FXML
    private CheckBox chcboxBranchAutomatica;
    @FXML
    private CheckBox chcboxBackupPastaNaoSalvo;
    @FXML
    private CheckBox chcboxMergeTrunk;
    @FXML
    private TextField textFieldBranch;
    @FXML
    private ComboBox<String> comboBoxCliente;
    @FXML
    private ComboBox<String> comboBoxSistema;
    @FXML
    private RadioButton radioButtonDelphi;
    @FXML
    private RadioButton radioButtonJava;
    @FXML
    private RadioButton radioButtonPhp;
    @FXML
    private RadioButton radioButtonDotNet;
    @FXML
    private RadioButton radioButtonEtl;
    @FXML
    private RadioButton radioButtonPrototipo;
    @FXML
    private RadioButton radioButtonBpmn;
    @FXML
    private RadioButton radioButtonVue;
    @FXML
    private RadioButton radioButtonReact;
    @FXML
    private RadioButton radioButtonAngular;
    @FXML
    private RadioButton radioButtonMobile;
    @FXML
    private Button buttonInicioDesenvolvimento;
    private AplicacaoForm aplicacaoForm;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            Object[] listas = this.getConsumoRestSingleton().listaCliente();
            this.comboBoxCliente.getItems().addAll(listas);
            listas = this.getConsumoRestSingleton().sistemasAtivos();
            this.comboBoxSistema.getItems().addAll(Arrays.stream(listas).sorted().toList());
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
        this.chcboxBranchAutomatica.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.textFieldBranch.setDisable(newValue.booleanValue());
            this.chcboxMergeTrunk.setDisable(newValue.booleanValue());
            this.chcboxMergeTrunk.setSelected(!this.chcboxMergeTrunk.isDisable());
        });
        this.chcboxMergeTrunk.setSelected(true);
        this.textFieldBranch.textProperty().addListener((observable, oldValue, newValue) -> {
            String value = Utils.extraiNumeroJira((String)newValue);
            this.textFieldBranch.setText(value);
        });
        this.textFieldBranch.focusedProperty().addListener((source, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                LogUtils.generate((String)"Entrou no campo");
            } else {
                if (this.textFieldBranch.getText().isEmpty()) {
                    return;
                }
                try {
                    String numeroSol = this.textFieldBranch.getText().trim().toUpperCase();
                    if (numeroSol.equals("1")) {
                        return;
                    }
                    DesenvolvimentoForm desenvolvimentoForm = this.getConsumoRestSingleton().carregaUltimaSolDesenvolvimento(this.getConfiguracaoSingleton().getLogin(), numeroSol);
                    if (desenvolvimentoForm != null) {
                        this.comboBoxCliente.getSelectionModel().select((Object)desenvolvimentoForm.getCliente());
                        this.comboBoxSistema.getSelectionModel().select((Object)desenvolvimentoForm.getSistema());
                        if (null != desenvolvimentoForm.getTecnologia()) {
                            switch (desenvolvimentoForm.getTecnologia()) {
                                case DELPHI: {
                                    this.radioButtonDelphi.selectedProperty().set(true);
                                    break;
                                }
                                case JAVA: {
                                    this.radioButtonJava.selectedProperty().set(true);
                                    break;
                                }
                                case PHP: {
                                    this.radioButtonPhp.selectedProperty().set(true);
                                    break;
                                }
                                case DOTNET: {
                                    this.radioButtonDotNet.selectedProperty().set(true);
                                    break;
                                }
                                case ETL: {
                                    this.radioButtonEtl.selectedProperty().set(true);
                                    break;
                                }
                                case PROTOTIPO: {
                                    this.radioButtonPrototipo.selectedProperty().set(true);
                                    break;
                                }
                                case BPMN: {
                                    this.radioButtonBpmn.selectedProperty().set(true);
                                    break;
                                }
                                case VUE: {
                                    this.radioButtonVue.selectedProperty().set(true);
                                    break;
                                }
                                case REACT: {
                                    this.radioButtonReact.selectedProperty().set(true);
                                    break;
                                }
                                case ANGULAR: {
                                    this.radioButtonAngular.selectedProperty().set(true);
                                    break;
                                }
                                case MOBILE: {
                                    this.radioButtonMobile.selectedProperty().set(true);
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LogUtils.generate((String)ex.getMessage());
                }
            }
        });
        Platform.runLater(this::chamaOnShow);
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent ignoredEvent) {
        try {
            if ((this.textFieldBranch.getText() == null || this.textFieldBranch.getText().isEmpty()) && !this.chcboxBranchAutomatica.isSelected()) {
                throw new Exception("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
            }
            if (this.comboBoxCliente.getSelectionModel() == null || this.comboBoxCliente.getSelectionModel().getSelectedItem() == null || ((String)this.comboBoxCliente.getSelectionModel().getSelectedItem()).isEmpty()) {
                throw new Exception("Cliente \u00e9 Obrigat\u00f3rio");
            }
            if (this.comboBoxSistema.getSelectionModel() == null || this.comboBoxSistema.getSelectionModel().getSelectedItem() == null || ((String)this.comboBoxSistema.getSelectionModel().getSelectedItem()).isEmpty()) {
                throw new Exception("Sistema \u00e9 Obrigat\u00f3rio");
            }
            TecnologiaType tecnologia = this.tecnologiaSelecionado();
            if (tecnologia == null) {
                throw new Exception("Tecnologia \u00e9 Obrigat\u00f3rio");
            }
            AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
        }
        catch (Exception ex) {
            MensagemView.getInstancia().mostraErro(this.anchorPane, ex.getMessage());
            return;
        }
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                InicioDesenvolvimentoController.this.startProcessLog();
                InicioDesenvolvimentoController.this.clearLog();
                InicioDesenvolvimentoController.this.criaTaskAtualizacaoLabel();
                InicioDesenvolvimentoController.this.aplicacaoForm = InicioDesenvolvimentoController.this.getConsumoRestSingleton().pesquisaAplicacao((String)InicioDesenvolvimentoController.this.comboBoxCliente.getSelectionModel().getSelectedItem(), (String)InicioDesenvolvimentoController.this.comboBoxSistema.getSelectionModel().getSelectedItem(), InicioDesenvolvimentoController.this.tecnologiaSelecionado());
                String sistema = (String)InicioDesenvolvimentoController.this.comboBoxSistema.getSelectionModel().getSelectedItem();
                if (InicioDesenvolvimentoController.this.chcboxBranchAutomatica.isSelected()) {
                    SvnFachada svnFachada = new SvnFachada(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha(), InicioDesenvolvimentoController.this.getOutputStream());
                    for (int numeroBranch = 2; numeroBranch < 9999999; ++numeroBranch) {
                        boolean existeGpd;
                        String branch = Long.toString(numeroBranch);
                        URL urlBranch = PastaUtil.getUrlBranch((String)InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getServidorSvn(), (String)InicioDesenvolvimentoController.this.aplicacaoForm.getProjetoSvn(), (String)branch);
                        InicioDesenvolvimentoController.this.appendLog("\nVerificando exist\u00eancia da BRANCH " + String.valueOf(urlBranch));
                        boolean existeSvn = svnFachada.existeRepositorio(urlBranch);
                        if (existeSvn || (existeGpd = RemoteFactory.getInstance().getProcessamento().existeDesenvolvimentoFinalizado(InicioDesenvolvimentoController.this.aplicacaoForm.getProjetoSvn(), sistema, branch))) continue;
                        InicioDesenvolvimentoController.this.textFieldBranch.setText(String.valueOf(numeroBranch));
                        break;
                    }
                }
                String cliente = (String)InicioDesenvolvimentoController.this.comboBoxCliente.getSelectionModel().getSelectedItem();
                DesenvolvimentoForm desenvolvimentoForm = new DesenvolvimentoForm();
                desenvolvimentoForm.setLogin(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin());
                desenvolvimentoForm.setSenha(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha());
                desenvolvimentoForm.setCliente(cliente);
                desenvolvimentoForm.setSistema(sistema);
                desenvolvimentoForm.setTecnologia(InicioDesenvolvimentoController.this.tecnologiaSelecionado());
                desenvolvimentoForm.setBranch(InicioDesenvolvimentoController.this.textFieldBranch.getText());
                this.validaPastaFormatoAntigo(desenvolvimentoForm);
                InicioDesenvolvimentoController.this.getDesenvolvimentoClientFachada().validaInicioDesenvolvimento(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), desenvolvimentoForm.getBranch(), desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia(), InicioDesenvolvimentoController.this.aplicacaoForm);
                List<StatusArquivoForm> listaArquivoNaoComitado = InicioDesenvolvimentoController.this.getDesenvolvimentoClientFachada().listaArquivoNaoComitado(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha(), InicioDesenvolvimentoController.this.aplicacaoForm, desenvolvimentoForm.getBranch(), InicioDesenvolvimentoController.this.getOutputStream()).stream().filter(a -> !SvnUtils.ignoraCommitArquivoOuPasta((String)a.getArquivo())).toList();
                if (!listaArquivoNaoComitado.isEmpty()) {
                    StringBuilder listaArquivos = new StringBuilder();
                    listaArquivoNaoComitado.forEach(a -> listaArquivos.append(a.getStatus()).append(" - ").append(a.getArquivo()).append("\n"));
                    InicioDesenvolvimentoController.this.updateLogWebView(listaArquivos.toString());
                    if (InicioDesenvolvimentoController.this.chcboxBackupPastaNaoSalvo.isSelected()) {
                        File pastaTrabalho = PastaUtil.getPastaTrabalho((String)InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), (String)InicioDesenvolvimentoController.this.aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                        int ano = LocalDate.now().getYear();
                        int mes = LocalDate.now().getMonth().getValue();
                        int dia = LocalDate.now().getDayOfMonth();
                        int hora = LocalDateTime.now().getHour();
                        int minuto = LocalDateTime.now().getMinute();
                        int segundo = LocalDateTime.now().getSecond();
                        File pastaBackup = new File(pastaTrabalho.getAbsolutePath().concat("_" + ano + NumberUtils.formatZeroLeft((Number)mes, (int)2) + NumberUtils.formatZeroLeft((Number)dia, (int)2) + NumberUtils.formatZeroLeft((Number)hora, (int)2) + NumberUtils.formatZeroLeft((Number)minuto, (int)2) + NumberUtils.formatZeroLeft((Number)segundo, (int)2)));
                        if (!pastaTrabalho.renameTo(pastaBackup)) {
                            throw new Exception("N\u00e3o foi poss\u00edvel fazer BACKUP da pasta " + pastaTrabalho.getAbsolutePath());
                        }
                    } else {
                        throw new Exception("Existe(m) arquivo(s) SEM COMMIT no WorkingCopy");
                    }
                }
                desenvolvimentoForm.setBranch(InicioDesenvolvimentoController.this.textFieldBranch.getText());
                InicioDesenvolvimentoController.this.getDesenvolvimentoClientFachada().inicioDesenvolvimento(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getServidorSvn(), InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha(), desenvolvimentoForm.getBranch(), desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia(), InicioDesenvolvimentoController.this.aplicacaoForm, InicioDesenvolvimentoController.this.chcboxMergeTrunk.isSelected(), InicioDesenvolvimentoController.this.getOutputStream());
                if (InicioDesenvolvimentoController.this.chcboxMergeTrunk.isSelected()) {
                    File pastaTrabalho = PastaUtil.getPastaTrabalho((String)InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), (String)InicioDesenvolvimentoController.this.aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                    URL urlTrunk = PastaUtil.getUrlTrunk((String)InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getServidorSvn(), (String)InicioDesenvolvimentoController.this.aplicacaoForm.getProjetoSvn());
                    BashUtils.execute(List.of("cd " + String.valueOf(pastaTrabalho), "svn merge --username " + InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin() + " --password " + InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha() + " " + String.valueOf(urlTrunk) + "."), (OutputStream)InicioDesenvolvimentoController.this.getOutputStream());
                    SvnFachada svnFachada = new SvnFachada(InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getSenha(), InicioDesenvolvimentoController.this.getOutputStream());
                    svnFachada.verificaConflito(pastaTrabalho);
                }
                return null;
            }

            private void validaPastaFormatoAntigo(DesenvolvimentoForm desenvolvimentoForm) throws Exception {
                File pastaTrabalho2 = PastaUtil.getPastaTrabalho((String)InicioDesenvolvimentoController.this.getConfiguracaoSingleton().getLogin(), (String)InicioDesenvolvimentoController.this.aplicacaoForm.getServidorDesenvolvimento(), (String)desenvolvimentoForm.getBranch());
                File parentDirectory = pastaTrabalho2.getParentFile();
                File svnDirectory = new File(parentDirectory, ".svn");
                if (svnDirectory.exists() && svnDirectory.isDirectory()) {
                    throw new Exception("Pasta " + svnDirectory.getParentFile().getName() + " est\u00e1 com o formato ANTIGO. Renomeie ou apague essa pasta para evitar confus\u00e3o.");
                }
            }

            protected void failed() {
                Platform.runLater(() -> {
                    LogUtils.generate((Throwable)this.getException());
                    InicioDesenvolvimentoController.this.endProcessLog();
                    InicioDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(InicioDesenvolvimentoController.this.anchorPane, this.getException().getMessage());
                    if (this.getException().getMessage().toLowerCase().contains("conflito")) {
                        InicioDesenvolvimentoController.this.abreTerminalClipboardResolveConflito();
                    }
                    InicioDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    InicioDesenvolvimentoController.this.endProcessLog();
                    String mensagem = "Processamento Conclu\u00eddo com Sucesso";
                    if (InicioDesenvolvimentoController.this.textFieldBranch.getText().equalsIgnoreCase("1") || InicioDesenvolvimentoController.this.chcboxMergeTrunk.isSelected() && InicioDesenvolvimentoController.this.getConfiguracaoSingleton().isUsuarioJessicaAraujo()) {
                        InicioDesenvolvimentoController.this.abreTerminalClipboardResolveConflito();
                    }
                    MensagemView.getInstancia().mostraSucesso(InicioDesenvolvimentoController.this.anchorPane, mensagem);
                    InicioDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void running() {
                InicioDesenvolvimentoController.this.desabilitaComponentes();
            }
        };
        new Thread((Runnable)task).start();
    }

    private void abreTerminalClipboardResolveConflito() {
        try {
            File pastaTrabalho = new File(PastaUtil.getPastaTrabalho((String)this.getConfiguracaoSingleton().getLogin(), (String)this.aplicacaoForm.getServidorDesenvolvimento(), (String)this.textFieldBranch.getText()).getAbsolutePath());
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString("cd " + pastaTrabalho.getAbsolutePath() + "; svn resolve .");
            Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
            if (AmbienteUtils.isLinux()) {
                Runtime.getRuntime().exec("gnome-terminal", null, pastaTrabalho);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TecnologiaType tecnologiaSelecionado() {
        TecnologiaType tecnologia = null;
        if (this.radioButtonDelphi.isSelected()) {
            tecnologia = TecnologiaType.DELPHI;
        } else if (this.radioButtonJava.isSelected()) {
            tecnologia = TecnologiaType.JAVA;
        } else if (this.radioButtonPhp.isSelected()) {
            tecnologia = TecnologiaType.PHP;
        } else if (this.radioButtonDotNet.isSelected()) {
            tecnologia = TecnologiaType.DOTNET;
        } else if (this.radioButtonEtl.isSelected()) {
            tecnologia = TecnologiaType.ETL;
        } else if (this.radioButtonPrototipo.isSelected()) {
            tecnologia = TecnologiaType.PROTOTIPO;
        } else if (this.radioButtonBpmn.isSelected()) {
            tecnologia = TecnologiaType.BPMN;
        } else if (this.radioButtonVue.isSelected()) {
            tecnologia = TecnologiaType.VUE;
        } else if (this.radioButtonReact.isSelected()) {
            tecnologia = TecnologiaType.REACT;
        } else if (this.radioButtonAngular.isSelected()) {
            tecnologia = TecnologiaType.ANGULAR;
        } else if (this.radioButtonMobile.isSelected()) {
            tecnologia = TecnologiaType.MOBILE;
        }
        return tecnologia;
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.chcboxBranchAutomatica.setDisable(disable);
            this.chcboxMergeTrunk.setDisable(disable);
            this.chcboxBackupPastaNaoSalvo.setDisable(disable);
            if (!this.chcboxBranchAutomatica.isSelected()) {
                this.textFieldBranch.setDisable(disable);
            }
            this.comboBoxCliente.setDisable(disable);
            this.comboBoxSistema.setDisable(disable);
            this.radioButtonDelphi.setDisable(disable);
            this.radioButtonJava.setDisable(disable);
            this.radioButtonPhp.setDisable(disable);
            this.radioButtonDotNet.setDisable(disable);
            this.radioButtonEtl.setDisable(disable);
            this.radioButtonPrototipo.setDisable(disable);
            this.radioButtonBpmn.setDisable(disable);
            this.radioButtonVue.setDisable(disable);
            this.radioButtonReact.setDisable(disable);
            this.radioButtonAngular.setDisable(disable);
            this.radioButtonMobile.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void chamaOnShow() {
        this.chcboxBranchAutomatica.setSelected(false);
        this.chcboxBackupPastaNaoSalvo.setSelected(false);
        this.chcboxMergeTrunk.setSelected(true);
        this.textFieldBranch.clear();
        this.comboBoxCliente.setValue(null);
        this.comboBoxSistema.setValue(null);
        this.radioButtonDelphi.setSelected(false);
        this.radioButtonDotNet.setSelected(false);
        this.radioButtonEtl.setSelected(false);
        this.radioButtonJava.setSelected(false);
        this.radioButtonPhp.setSelected(false);
        this.radioButtonPrototipo.setSelected(false);
        this.radioButtonBpmn.setSelected(false);
        this.radioButtonVue.setSelected(false);
        this.radioButtonReact.setSelected(false);
        this.radioButtonAngular.setSelected(false);
        this.radioButtonMobile.setSelected(false);
        this.clearLog();
    }
}

