/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.util.VariavelAmbiente;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;

@Singleton
public class HomeController
extends BaseFxml {
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private Label labelTitulo;
    @FXML
    private Label labelTituloInicioDesenvolvimento;
    @FXML
    private TableView<DesenvolvimentoForm> tableViewSol;
    @FXML
    private Label labelUrlGpd;
    @FXML
    private Label labelWorkingCopy;
    @FXML
    private ProgressIndicator progressIndicator;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.configuraTitulo();
        this.configuraDataTable();
        this.configuraRodape();
        this.criaTaskAtualizacaoGrid();
    }

    private void configuraDataTable() {
        this.getDesenvolvimentoClientFachada().criaColunasTableViewSol(this.tableViewSol);
    }

    private void configuraRodape() {
        this.labelUrlGpd.setText(this.getConfiguracaoSingleton().getUrlGpd());
        this.labelWorkingCopy.setText(VariavelAmbiente.getInterno());
    }

    private void configuraTitulo() {
        if (this.getConfiguracaoSingleton().isDsfCg()) {
            this.labelTitulo.setText("GPD - DSF CG - 25.10.2.1237");
        } else if (this.getConfiguracaoSingleton().isDsfSp()) {
            this.labelTitulo.setText("GPD - DSF SP - 25.10.2.1237");
        } else {
            this.labelTitulo.setText("GPD - LOCAL N\u00c3O IDENTIFICADO");
        }
    }

    public void criaTaskAtualizacaoGrid() {
        Platform.runLater(() -> this.progressIndicator.setVisible(true));
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                List<DesenvolvimentoForm> listaSolsAberto = HomeController.this.getConsumoRestSingleton().listaSolsDesenvolvimento();
                ObservableList data = FXCollections.observableArrayList(listaSolsAberto);
                Platform.runLater(() -> HomeController.this.tableViewSol.setItems(data));
                return null;
            }

            protected void succeeded() {
                HomeController.this.progressIndicator.setVisible(false);
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    public void refreshData() {
        this.criaTaskAtualizacaoGrid();
    }
}

