/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.util;

import br.com.dsfnet.gpd.client.type.UtilizadorType;
import br.com.jarch.core.model.type.DataBaseType;
import jakarta.inject.Singleton;

@Singleton
public class ConfiguracaoSingleton {
    private String login;
    private String senha;
    private String loginSshLocal;
    private String passwordSshLocal;
    private boolean ambienteDebug;
    private UtilizadorType utilizador;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getLoginSshLocal() {
        return this.loginSshLocal;
    }

    public void setLoginSshLocal(String loginSshLocal) {
        this.loginSshLocal = loginSshLocal;
    }

    public String getPasswordSshLocal() {
        return this.passwordSshLocal;
    }

    public void setPasswordSshLocal(String passwordSshLocal) {
        this.passwordSshLocal = passwordSshLocal;
    }

    public String getServidorSvn() {
        if (this.utilizador == null) {
            return UtilizadorType.NAO_IDENTIFICADO.getUrlSvn();
        }
        return this.utilizador.getUrlSvn();
    }

    public String getUrlGpd() {
        return "http://" + this.getServidorGpd() + ":8080/gpd-web";
    }

    public String getServidorGpd() {
        if (this.ambienteDebug) {
            return "localhost";
        }
        return "10.103.1.182";
    }

    public String getSenhaBancoDados() {
        return "d$f1nt3rn0";
    }

    public String getUsuarioBancoDados() {
        return "dsfinterno";
    }

    public String getStringConexaoBancoDados() {
        return "jdbc:oracle:thin:@(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL = TCP)(HOST = 192.168.10.35)(PORT = 1521))) (CONNECT_DATA = (SERVER = DEDICATED) (SERVICE_NAME = DSFPRD)) )";
    }

    public DataBaseType getTipoBancoDados() {
        return DataBaseType.ORACLE;
    }

    public boolean isAmbienteDebug() {
        return this.ambienteDebug;
    }

    public void setAmbienteDebug(boolean ambienteDebug) {
        this.ambienteDebug = ambienteDebug;
    }

    public UtilizadorType getUtilizador() {
        return this.utilizador;
    }

    public void setUtilizador(UtilizadorType utilizador) {
        this.utilizador = utilizador;
    }

    public boolean isDsfSp() {
        return this.utilizador == UtilizadorType.DSF_SP;
    }

    public boolean isDsfCg() {
        return this.utilizador == UtilizadorType.DSF_CG;
    }

    public boolean isNaoIdentificado() {
        return this.utilizador == UtilizadorType.NAO_IDENTIFICADO;
    }

    public void localDsfSp() {
        this.utilizador = UtilizadorType.DSF_SP;
    }

    public void localDsfCg() {
        this.utilizador = UtilizadorType.DSF_CG;
    }

    public void localNaoIdentificado() {
        this.utilizador = UtilizadorType.NAO_IDENTIFICADO;
    }

    public void ambienteDebug() {
        this.ambienteDebug = true;
    }

    public boolean isPodePublicar() {
        return this.login != null && (this.login.contains("wagner.araujo") || this.login.contains("bruno.araujo") || this.login.contains("jessica.araujo") || this.login.contains("giovanni.fink") || this.login.contains("yan.fink") || this.login.contains("marcos.fink") || this.login.contains("marcelo.grecco"));
    }

    public boolean isUsuarioBrunoAraujo() {
        return this.login != null && this.login.contains("bruno.araujo");
    }

    public boolean isUsuarioJessicaAraujo() {
        return this.login != null && this.login.contains("jessica.araujo");
    }
}

