/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.versionamento;

import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoRepository;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoRepository;
import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.exception.VersionamentoException;
import br.com.dsfnet.gpd.client.parametro.ParametroRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoRepository;
import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.svn.SvnFachada;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Set;

@JArchService
public class VersionamentoService
extends CrudService<VersionamentoEntity, VersionamentoRepository> {
    public static VersionamentoService getInstance() {
        return (VersionamentoService)((Object)CDI.current().select(VersionamentoService.class, new Annotation[0]).get());
    }

    public List<DesenvolvimentoEntity> carregaListaIndividualInicioVersionamento() {
        return DesenvolvimentoRepository.getInstance().listaNaoEmpacotadoNaoVersionado();
    }

    public List<EmpacotamentoEntity> carregaListaPacoteInicioVersionamento() {
        return EmpacotamentoRepository.getInstance().listaNaoVersionado();
    }

    public void validacaoInicioVersionamento(PublicacaoType publicacaoType, Long idDesenvolvimento, Long idEmpacotamento) throws VersionamentoException {
        if (publicacaoType == null) {
            throw new VersionamentoException("Selecione o tipo de publica\u00e7\u00e3o");
        }
        if (publicacaoType == PublicacaoType.INDIVIDUAL) {
            DesenvolvimentoEntity desenvolvimentoEntity = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(idDesenvolvimento);
            if (desenvolvimentoEntity == null) {
                throw new VersionamentoException("Vers\u00e3o/Branch\u00e9 de preenchimento obrigat\u00f3rio");
            }
            if (VersionamentoRepository.getInstance().existeAbertoWorkingCopy(desenvolvimentoEntity.getSistemaEntity().getServidorVersionamento())) {
                throw new VersionamentoException("Existem um versionamento em andamento para essa aplica\u00e7\u00e3o");
            }
        }
        if (publicacaoType == PublicacaoType.PACOTE) {
            EmpacotamentoEntity empacotamentoEntity = (EmpacotamentoEntity)EmpacotamentoRepository.getInstance().find(idEmpacotamento);
            if (empacotamentoEntity == null) {
                throw new VersionamentoException("Vers\u00e3o/Branch\u00e9 de preenchimento obrigat\u00f3rio");
            }
            if (VersionamentoRepository.getInstance().existeAbertoWorkingCopy(empacotamentoEntity.getSistemaEntity().getServidorVersionamento())) {
                throw new VersionamentoException("Existem um versionamento em andamento para essa aplica\u00e7\u00e3o");
            }
        }
    }

    public VersionamentoEntity atualizacaoBancoDadosInicioVersionamento(String loginSvn, PublicacaoType publicacaoType, Long idDesenvolvimento, Long idEmpacotamento) {
        String numeroSol;
        String versao;
        SistemaEntity sistemaEntity;
        if (publicacaoType == PublicacaoType.INDIVIDUAL) {
            DesenvolvimentoEntity desenvolvimentoEntity = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(idDesenvolvimento);
            sistemaEntity = desenvolvimentoEntity.getSistemaEntity();
            versao = null;
            numeroSol = desenvolvimentoEntity.getNumeroSol();
        } else {
            EmpacotamentoEntity empacotamentoEntity = (EmpacotamentoEntity)EmpacotamentoRepository.getInstance().find(idEmpacotamento);
            sistemaEntity = empacotamentoEntity.getSistemaEntity();
            versao = empacotamentoEntity.getVersao();
            numeroSol = null;
        }
        VersionamentoEntity versionamentoEntity = publicacaoType == PublicacaoType.INDIVIDUAL ? VersionamentoRepository.getInstance().bloquear(sistemaEntity.getId(), loginSvn, numeroSol, null) : VersionamentoRepository.getInstance().bloquear(sistemaEntity.getId(), loginSvn, null, versao);
        return versionamentoEntity;
    }

    public Set<VersionamentoEntity> carregaListaDescarteVersionamento() {
        return VersionamentoRepository.getInstance().listaAberto();
    }

    public void validacaoDescarteVersionamento(Long idVersionamento) throws VersionamentoException {
        if (idVersionamento == null) {
            throw new VersionamentoException("Selecione o Versionamento");
        }
    }

    public void atualizacaoBancoDadosDescarteVersionamento(String loginSvn, Long idVersionamento) {
        VersionamentoRepository.getInstance().descartar(idVersionamento, loginSvn);
    }

    public Set<VersionamentoEntity> carregaListaIndividualFimVersionamento() {
        return VersionamentoRepository.getInstance().listaSolNaoFinalizado();
    }

    public Set<VersionamentoEntity> carregaListaPacoteFimVersionamento() {
        return VersionamentoRepository.getInstance().listaVersaoNaoFinalizado();
    }

    public void validacaoFimVersionamento(Long idVersionamento, String nomeArquivo, byte[] streamArquivo) throws VersionamentoException {
        if (idVersionamento == null) {
            throw new VersionamentoException("Vers\u00e3o/Branch\u00e9 de preenchimento obrigat\u00f3rio");
        }
        VersionamentoEntity versionamentoEntity = (VersionamentoEntity)VersionamentoRepository.getInstance().find(idVersionamento);
        if (versionamentoEntity.getSistemaEntity().getTecnologia().pacoteObrigatorio() && ParametroRepository.getInstance().pesquisaChave("GPD.OBRIGATORIO.SUBIR.PACOTE", "S").equals("S") && streamArquivo == null) {
            throw new VersionamentoException("Pacote para publica\u00e7\u00e3o N\u00c3O selecionado");
        }
        if (versionamentoEntity.getSistemaEntity().getTecnologia().pacoteObrigatorio() && streamArquivo != null && streamArquivo.length == 0) {
            throw new VersionamentoException("Pacote para publica\u00e7\u00e3o est\u00e1 vazio (0 bytes)");
        }
        if (versionamentoEntity.getSistemaEntity().getNomePacote() == null && ParametroRepository.getInstance().pesquisaChave("GPD.OBRIGATORIO.SUBIR.PACOTE", "S").equals("S") && versionamentoEntity.getSistemaEntity().getPacotes() != null && !versionamentoEntity.getSistemaEntity().getPacotes().contains(nomeArquivo)) {
            throw new VersionamentoException("Nome de pacote inv\u00e1lido. Somente um dos pacotes " + versionamentoEntity.getSistemaEntity().getPacotes().replaceAll(",", " / ") + " ser\u00e1 aceito");
        }
    }

    public String geraNumeracaoTag(String servidorSvn, String loginSvn, String senhaSvn, PublicacaoType publicacaoType, Long idVersionamento) throws Exception {
        VersionamentoEntity versionamentoEntity = (VersionamentoEntity)VersionamentoRepository.getInstance().find(idVersionamento);
        String retorno = publicacaoType == PublicacaoType.INDIVIDUAL ? SistemaRepository.getInstance().atualizaTagVersao4(versionamentoEntity.getSistemaEntity().getCliente(), versionamentoEntity.getSistemaEntity().getSistema(), versionamentoEntity.getSistemaEntity().getTecnologia()) : SistemaRepository.getInstance().atualizaTagVersao3(versionamentoEntity.getSistemaEntity().getCliente(), versionamentoEntity.getSistemaEntity().getSistema(), versionamentoEntity.getSistemaEntity().getTecnologia());
        SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, null);
        URL urlTag = PastaUtil.getUrlTag(servidorSvn, versionamentoEntity.getSistemaEntity().getProjetoSvn(), retorno);
        if (svnFachada.existeRepositorio(urlTag)) {
            retorno = this.geraNumeracaoTag(servidorSvn, loginSvn, senhaSvn, publicacaoType, versionamentoEntity.getId());
        }
        return retorno;
    }

    public void atualizacaoBancoDadosFimVersionamento(PublicacaoType publicacaoType, Long idVersionamento, String tag, String nomeArquivo, byte[] streamArquivo) throws PacoteException {
        VersionamentoRepository.getInstance().liberar(idVersionamento, publicacaoType, tag, nomeArquivo, streamArquivo);
    }
}

