/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.versionamento;

import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.pacote.PacoteRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.type.StatusPublicacaoType;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import br.com.jarch.util.LogUtils;
import jakarta.ejb.AccessTimeout;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class VersionamentoDao
extends CrudDao<VersionamentoEntity>
implements VersionamentoRepository {
    @Override
    @Transactional
    public VersionamentoEntity bloquear(Long aplicacaoId, String login, String numeroSol, String versao) {
        SistemaEntity sistemaEntity = (SistemaEntity)SistemaRepository.getInstance().find(aplicacaoId);
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
        VersionamentoEntity versionamento = new VersionamentoEntity();
        versionamento.setVersao(versao);
        versionamento.setNumeroSol(numeroSol);
        versionamento.setSistemaEntity(sistemaEntity);
        versionamento.setInicio(new Date());
        versionamento.setStatus(StatusType.BLOQUEADO);
        versionamento.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)versionamento);
        return versionamento;
    }

    @Override
    @AccessTimeout(value=-1L)
    @Transactional
    public void liberar(Long id, PublicacaoType publicacao, String tag, String nomeArquivoPublicacao, byte[] pacotePublicacao) throws PacoteException {
        VersionamentoEntity versionamento = (VersionamentoEntity)this.getEntityManager().find(VersionamentoEntity.class, (Object)id);
        if (pacotePublicacao != null) {
            PacoteRepository.getInstance().gravar(versionamento.getSistemaEntity().getSistema(), versionamento.getSistemaEntity().getTecnologia(), versionamento.getSistemaEntity().getCliente(), tag, pacotePublicacao, nomeArquivoPublicacao);
        }
        versionamento.setTag(tag);
        versionamento.setFim(new Date());
        versionamento.setStatus(StatusType.LIBERADO);
        this.gravaTagDesmembrado(versionamento);
        this.getEntityManager().merge((Object)versionamento);
    }

    @Override
    public Set<VersionamentoEntity> listaVersaoNaoFinalizado() {
        Query query = this.getEntityManager().createQuery("SELECT v FROM VersionamentoEntity v WHERE v.versao IS NOT NULL AND       v.fim IS NULL AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = v.sistemaEntity.id AND                         x.versao = v.versao AND                         x.status = :status AND                         NOT EXISTS( SELECT 0                                     FROM PublicacaoEntity y                                     WHERE y.sistemaEntity.id = x.sistemaEntity.id AND                                           y.tag = x.tag))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(VersionamentoEntity.class, (Collection)query.getResultList());
        TreeSet<VersionamentoEntity> listaRetorno = new TreeSet<VersionamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<VersionamentoEntity> listaSolNaoFinalizado() {
        Query query = this.getEntityManager().createQuery("SELECT v FROM VersionamentoEntity v WHERE v.numeroSol IS NOT NULL AND       v.fim IS NULL AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = v.sistemaEntity.id AND                         x.status = :status AND                         x.versao = v.versao AND                         NOT EXISTS( SELECT 0                                     FROM PublicacaoEntity y                                     WHERE y.sistemaEntity.id = x.sistemaEntity.id AND                                           y.tag = x.tag AND                                           y.status = :status))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(VersionamentoEntity.class, (Collection)query.getResultList());
        TreeSet<VersionamentoEntity> listaRetorno = new TreeSet<VersionamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public List<VersionamentoEntity> listaUltimoAplicacao() {
        Query query = this.getEntityManager().createQuery("SELECT v FROM VersionamentoEntity v   JOIN FETCH v.sistemaEntity apl   JOIN FETCH v.usuarioEntity usu WHERE NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = v.sistemaEntity.id AND                         x.id > v.id) ORDER BY v.inicio DESC");
        return CollectionUtils.transform(VersionamentoEntity.class, (Collection)query.getResultList());
    }

    @Override
    public boolean existeAbertoWorkingCopy(String workingCopy) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("servidorVersionamento"), (Object)workingCopy);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        criteria.where(new Predicate[]{whereAplicacao, whereFim});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return lista.size() > 0;
    }

    @Override
    public Set<VersionamentoEntity> listaPublicacao() {
        Query query = this.getEntityManager().createQuery("SELECT v FROM VersionamentoEntity v JOIN FETCH v.sistemaEntity WHERE v.tag IS NOT NULL AND       v.status = :liberado AND   \t   NOT EXISTS( SELECT 0                   FROM PublicacaoEntity x                   WHERE x.sistemaEntity.id = v.sistemaEntity.id AND                         x.status = :publicado AND \t   \t\t\t\t\t(          \t\t\t\t\t(x.tagVersao1 > v.tagVersao1) OR          \t\t\t\t\t(x.tagVersao1 = v.tagVersao1 AND x.tagVersao2 > v.tagVersao2) OR          \t\t\t\t\t(x.tagVersao1 = v.tagVersao1 AND x.tagVersao2 = v.tagVersao2 AND x.tagVersao3 > v.tagVersao3) OR          \t\t\t\t\t(x.tagVersao1 = v.tagVersao1 AND x.tagVersao2 = v.tagVersao2 AND x.tagVersao3 = v.tagVersao3 AND x.tagVersao4 >= v.tagVersao4)       \t\t\t\t\t)    \t\t\t)ORDER BY v DESC");
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        query.setParameter("publicado", (Object)StatusPublicacaoType.PUBLICADO);
        List lista = CollectionUtils.transform(VersionamentoEntity.class, (Collection)query.getResultList());
        TreeSet<VersionamentoEntity> listaRetorno = new TreeSet<VersionamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<VersionamentoEntity> listaAberto() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        criteria.where((Expression)whereFim);
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<VersionamentoEntity> listaRetorno = new TreeSet<VersionamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    @Transactional
    public void descartar(Long id, String login) {
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
        VersionamentoEntity versionamento = (VersionamentoEntity)this.find(id);
        versionamento.setFim(new Date());
        versionamento.setStatus(StatusType.DESCARTADO);
        versionamento.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().merge((Object)versionamento);
    }

    @Override
    public VersionamentoEntity pesquisar(Long aplicacaoId, String tag) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereTag = builder.equal((Expression)root.get("tag"), (Object)tag);
        criteria.where(new Predicate[]{whereAplicacao, whereTag});
        VersionamentoEntity retorno = (VersionamentoEntity)this.getEntityManager().createQuery(criteria).getSingleResult();
        return retorno;
    }

    @Override
    public boolean canceladoPublicacao(Long aplicacaoId, String versao) {
        Query query = this.getEntityManager().createQuery("SELECT v FROM VersionamentoEntity v WHERE v.sistemaEntity.id = :aplicacaoId AND \t   v.versao = :versao AND       v.status = :descartado AND       EXISTS( SELECT 0        \t   FROM PublicacaoEntity x       \t       WHERE x.sistemaEntity.id = v.sistemaEntity.id AND       \t \t\t\t x.tag = v.tag AND                     x.status = :cancelado)");
        query.setParameter("aplicacaoId", (Object)aplicacaoId);
        query.setParameter("versao", (Object)versao);
        query.setParameter("descartado", (Object)StatusType.DESCARTADO);
        query.setParameter("cancelado", (Object)StatusPublicacaoType.CANCELADO);
        List lista = CollectionUtils.transform(VersionamentoEntity.class, (Collection)query.getResultList());
        return lista.size() > 0;
    }

    @Override
    public List<VersionamentoEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<VersionamentoEntity> pesquisaVersaoAplicacao(String versao, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereVersao, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<VersionamentoEntity> pesquisaVersaoAplicacao(List<String> listaVersao, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate[] wheresOr = new Predicate[listaVersao.size()];
        int i = 0;
        for (String versao : listaVersao) {
            wheresOr[i++] = builder.equal((Expression)root.get("versao"), (Object)versao);
        }
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereAplicacao, builder.or(wheresOr)});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    @Transactional
    public void ajustaTags() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(VersionamentoEntity.class);
        Root root = criteria.from(VersionamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereTag = builder.isNotNull((Expression)root.get("tag"));
        Predicate whereTag1 = builder.isNull((Expression)root.get("tagVersao1"));
        Predicate whereTag2 = builder.isNull((Expression)root.get("tagVersao2"));
        Predicate whereTag3 = builder.isNull((Expression)root.get("tagVersao3"));
        Predicate whereTag4 = builder.isNull((Expression)root.get("tagVersao4"));
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereTag, whereTag1, whereTag2, whereTag3, whereTag4});
        criteria.orderBy(new Order[]{orderById});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        for (VersionamentoEntity versionamento : lista) {
            this.gravaTagDesmembrado(versionamento);
            this.getEntityManager().merge((Object)versionamento);
        }
    }

    private void gravaTagDesmembrado(VersionamentoEntity versionamento) {
        String tag = versionamento.getTag();
        if (tag == null || tag.isEmpty()) {
            return;
        }
        LogUtils.generate((String)("##### TAG #### " + tag));
        long tagVersao1 = new Long(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao2 = new Long(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao3 = new Long(tag.substring(0, tag.indexOf(".")));
        tag = tag.substring(tag.indexOf(".") + 1);
        long tagVersao4 = new Long(tag);
        LogUtils.generate((String)("Tag: " + versionamento.getTag() + " - Desmembrado: " + tagVersao1 + "." + tagVersao2 + "." + tagVersao3 + "." + tagVersao4));
        versionamento.setTagVersao1(tagVersao1);
        versionamento.setTagVersao2(tagVersao2);
        versionamento.setTagVersao3(tagVersao3);
        versionamento.setTagVersao4(tagVersao4);
    }
}

