/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public enum LocalType {
    DSF("DSF", "DSF"),
    BEL("BEL", "Bel\u00e9m"),
    CGR("CGR", "Campo Grande"),
    CMG("CMG", "Corumb\u00e1"),
    CPQ("CPQ", "Campinas"),
    GYN("GYN", "Goi\u00e2nia"),
    JPA("JPA", "Jo\u00e3o Pessoa"),
    MCP("MCP", "Macap\u00e1"),
    MCZ("MCZ", "Mac\u00e9io"),
    MOD("MOD", "Modelo"),
    PCNI("PCNI", "Nova Igua\u00e7u"),
    SJC("SJC", "S\u00e3o Jos\u00e9 dos Campos"),
    SLS("SlS", "S\u00e3o Louren\u00e7o da Serra"),
    SLZ("SJZ", "S\u00e3o Luiz"),
    SOD("SOD", "Sorocaba"),
    THE("THE", "Teresina"),
    UDI("UDI", "Uberl\u00e2ndia");

    private final String abbreviation;
    private final String description;

    private LocalType(String abbreviation, String description) {
        this.abbreviation = abbreviation;
        this.description = description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public static LocalType abbreviationToEnum(String abbreviation) {
        return Arrays.stream(LocalType.values()).filter(m -> m.getAbbreviation().equals(abbreviation)).findAny().orElse(null);
    }

    public static LocalType descriptionToEnum(String description) {
        return Arrays.stream(LocalType.values()).filter(m -> m.getDescription().equals(description)).findAny().orElse(null);
    }

    public static Collection<LocalType> getCollection() {
        return Arrays.stream(LocalType.values()).collect(Collectors.toCollection(ArrayList::new));
    }

    public String toString() {
        return this.getDescription();
    }
}

