/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.publicacao;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.StatusPublicacaoType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="PUBLICACAO")
@SequenceGenerator(name="PublicacaoIdSequence", sequenceName="SEQ_PUBLICACAO_ID", allocationSize=1)
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
public class PublicacaoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PublicacaoIdSequence")
    private Long id;
    private String tag;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date data;
    @Column(name="data_cancelamento")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataCancelamento;
    @Enumerated(value=EnumType.STRING)
    private StatusPublicacaoType status;
    @Column(name="tag_versao1")
    private Long tagVersao1;
    @Column(name="tag_versao2")
    private Long tagVersao2;
    @Column(name="tag_versao3")
    private Long tagVersao3;
    @Column(name="tag_versao4")
    private Long tagVersao4;
    @OneToOne
    @JoinColumn(name="aplicacao_id")
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id")
    private UsuarioEntity usuarioEntity;
    @OneToOne
    @JoinColumn(name="usuario_cancelamento_id")
    private UsuarioEntity usuarioCancelamentoEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public StatusPublicacaoType getStatus() {
        return this.status;
    }

    public void setStatus(StatusPublicacaoType status) {
        this.status = status;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Long getTagVersao1() {
        return this.tagVersao1;
    }

    public void setTagVersao1(Long tagVersao1) {
        this.tagVersao1 = tagVersao1;
    }

    public Long getTagVersao2() {
        return this.tagVersao2;
    }

    public void setTagVersao2(Long tagVersao2) {
        this.tagVersao2 = tagVersao2;
    }

    public Long getTagVersao3() {
        return this.tagVersao3;
    }

    public void setTagVersao3(Long tagVersao3) {
        this.tagVersao3 = tagVersao3;
    }

    public Long getTagVersao4() {
        return this.tagVersao4;
    }

    public void setTagVersao4(Long tagVersao4) {
        this.tagVersao4 = tagVersao4;
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    public UsuarioEntity getUsuarioCancelamentoEntity() {
        return this.usuarioCancelamentoEntity;
    }

    public void setUsuarioCancelamentoEntity(UsuarioEntity usuarioCancelamentoEntity) {
        this.usuarioCancelamentoEntity = usuarioCancelamentoEntity;
    }

    public int compareTo(PublicacaoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getTag() != null && outro.getTag() != null) {
            return this.getTag().compareTo(outro.getTag());
        }
        return this.getId().compareTo(outro.getId());
    }
}

