/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.planejamento;

import br.com.dsfnet.gpd.client.form.PlanejamentoForm;
import br.com.dsfnet.gpd.client.kanban.KanbanEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity_;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoRepository;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JArchDao
public class PlanejamentoDao
extends CrudDao<PlanejamentoEntity>
implements PlanejamentoRepository {
    @Override
    public PlanejamentoEntity incluir(Long aplicacaoId, String[] numeroSols, String versao, String login, KanbanEntity kanbanEntity) {
        return this.incluir(aplicacaoId, Arrays.stream(numeroSols).collect(Collectors.toSet()), versao, login, kanbanEntity);
    }

    @Override
    @Transactional
    public PlanejamentoEntity incluir(Long aplicacaoId, Set<String> numeroSols, String versao, String login, KanbanEntity kanbanEntity) {
        SistemaEntity aplicacao = (SistemaEntity)SistemaRepository.getInstance().find(aplicacaoId);
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        PlanejamentoEntity planejamento = new PlanejamentoEntity();
        planejamento.setData(new Date());
        planejamento.setVersao(versao);
        planejamento.setSistemaEntity(aplicacao);
        planejamento.setUsuarioEntity(usuario);
        planejamento.setKanbanEntity(kanbanEntity);
        for (String numeroSol : numeroSols) {
            PlanejamentoSolEntity planejamentoSol = new PlanejamentoSolEntity();
            planejamentoSol.setNumeroSol(numeroSol);
            planejamentoSol.setData(new Date());
            planejamentoSol.setUsuarioEntity(usuario);
            planejamento.addSol(planejamentoSol);
        }
        this.getEntityManager().persist((Object)planejamento);
        return planejamento;
    }

    @Override
    @Transactional
    public void alterar(PlanejamentoEntity planejamento, Set<String> solsSelecionadas, String login, KanbanEntity kanbanEntity) {
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        PlanejamentoEntity planejamentoEntity = (PlanejamentoEntity)this.find(planejamento.getId());
        planejamentoEntity.setData(new Date());
        planejamentoEntity.setUsuarioEntity(usuario);
        planejamentoEntity.setKanbanEntity(kanbanEntity);
        if (solsSelecionadas != null && !solsSelecionadas.isEmpty()) {
            planejamentoEntity.getListaSol().forEach(ps -> ps.setPlanejamentoEntity(null));
            planejamentoEntity.getListaSol().forEach(ps -> this.getEntityManager().remove(ps));
            planejamentoEntity.getListaSol().clear();
            for (String sol : solsSelecionadas) {
                PlanejamentoSolEntity planejamentoSolEntity = new PlanejamentoSolEntity();
                planejamentoSolEntity.setNumeroSol(sol.toString());
                planejamentoSolEntity.setData(new Date());
                planejamentoSolEntity.setUsuarioEntity(usuario);
                planejamentoSolEntity.setPlanejamentoEntity(planejamentoEntity);
                planejamentoEntity.addSol(planejamentoSolEntity);
            }
        }
        this.getEntityManager().merge((Object)planejamentoEntity);
    }

    @Override
    public PlanejamentoEntity pesquisar(Long id) {
        return (PlanejamentoEntity)this.getClientJpql().fetchJoin(PlanejamentoEntity_.sistemaEntity).fetchJoin(PlanejamentoEntity_.listaSol).where().equalsTo(PlanejamentoEntity_.id, (Object)id).collect().single();
    }

    @Override
    public List<String> listaVersaoAberto() {
        Query query = this.getEntityManager().createQuery("SELECT ad.versao FROM PlanejamentoEntity ad WHERE NOT EXISTS( SELECT x                   FROM EmpacotamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = ad.sistemaEntity.id AND                         x.versao = ad.versao )ORDER BY ad.versao");
        return CollectionUtils.transform(String.class, (Collection)query.getResultList());
    }

    @Override
    public Set<String> listaSol(String cliente, String produto, TecnologiaType tecnologia, String versao) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(String.class);
        Root root = criteriaQuery.from(PlanejamentoEntity.class);
        criteriaQuery.multiselect(new Selection[]{root.join("listaSol").get("numeroSol")});
        Predicate whereCliente = criteriaBuilder.equal((Expression)root.join("sistemaEntity").get("cliente"), (Object)cliente);
        Predicate whereSistema = criteriaBuilder.equal((Expression)root.join("sistemaEntity").get("sistema"), (Object)produto);
        Predicate whereTecnologia = criteriaBuilder.equal((Expression)root.join("sistemaEntity").get("tecnologia"), (Object)tecnologia);
        Predicate whereVersao = criteriaBuilder.equal((Expression)root.get("versao"), (Object)versao);
        criteriaQuery.where(new Predicate[]{whereCliente, whereSistema, whereTecnologia, whereVersao});
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.join("listaSol").get("numeroSol"))});
        return new TreeSet<String>(this.getEntityManager().createQuery(criteriaQuery).getResultList());
    }

    @Override
    public List<PlanejamentoForm> listaVersaoServidor() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + PlanejamentoForm.class.getName() + "(apl.sistema, apl.cliente, apl.tecnologia, planej.versao, sol.numeroSol, 'PLANEJADA', planej.data, usu.login) FROM PlanejamentoEntity planej JOIN planej.sistemaEntity apl JOIN planej.listaSol sol JOIN planej.usuarioEntity usu WHERE NOT EXISTS( SELECT 0                   FROM EmpacotamentoEntity x                   WHERE x.sistemaEntity.id = planej.sistemaEntity.id AND                         x.versao = planej.versao AND                         x.numeroSol = sol.numeroSol) ORDER BY planej.data DESC");
        return CollectionUtils.transform(PlanejamentoForm.class, (Collection)query.getResultList());
    }

    @Override
    public Set<PlanejamentoEntity> listaPlanejamento() {
        Query query = this.getEntityManager().createQuery("SELECT p FROM PlanejamentoEntity p   JOIN FETCH p.listaSol ps WHERE NOT EXISTS( SELECT x                   FROM EmpacotamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = p.sistemaEntity.id AND                         x.versao = p.versao AND \t                     x.inicio > p.data)");
        List lista = CollectionUtils.transform(PlanejamentoEntity.class, (Collection)query.getResultList());
        return new TreeSet<PlanejamentoEntity>(lista);
    }

    @Override
    public Set<PlanejamentoSolEntity> listaEmpacotamentoIniciar(String login) {
        Query query = this.getEntityManager().createQuery("SELECT ps FROM PlanejamentoSolEntity ps WHERE NOT EXISTS( SELECT x                   FROM EmpacotamentoEntity x  \t\t\t\t   WHERE x.sistemaEntity.id = ps.planejamentoEntity.sistemaEntity.id AND                         x.versao = ps.planejamentoEntity.versao AND \t\t\t\t\t\t x.numeroSol = ps.numeroSol ) AND \t   EXISTS( SELECT x               FROM EmpacotamentoEntity x  \t\t\t   WHERE x.sistemaEntity.id = ps.planejamentoEntity.sistemaEntity.id AND                     x.versao = ps.planejamentoEntity.versao AND                     x.usuarioEntity.login = :login) AND       EXISTS( SELECT x               FROM HomologacaoEntity x               WHERE x.sistemaEntity.id = ps.planejamentoEntity.sistemaEntity.id AND                     x.numeroSol = ps.numeroSol AND                     (x.fim >= ( SELECT MAX(y.fim)                                FROM DesenvolvimentoEntity y                                WHERE y.sistemaEntity.id = x.sistemaEntity.id AND                                      y.numeroSol = x.numeroSol AND                                      y.status = :liberado AND                                      NOT EXISTS( SELECT z       \t\t\t\t\t\t\t\t\t\t \t  FROM DesenvolvimentoEntity z                                                  WHERE z.sistemaEntity.id = y.sistemaEntity.id AND \t\t\t\t\t\t\t\t\t\t\t\t\t\tz.numeroSol = y.numeroSol AND                                                        z.status = :liberado AND \t\t\t\t\t\t\t\t\t\t\t\t\t\tz.id > y.id))))");
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        query.setParameter("login", (Object)login);
        List lista = CollectionUtils.transform(PlanejamentoSolEntity.class, (Collection)query.getResultList());
        TreeSet<PlanejamentoSolEntity> listaRetorno = new TreeSet<PlanejamentoSolEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<PlanejamentoEntity> listaEmpacotamentoFechar(String login) {
        Query query = this.getEntityManager().createQuery("SELECT p FROM PlanejamentoEntity p WHERE ( SELECT COUNT(x)         FROM PlanejamentoSolEntity x  \t\t WHERE x.planejamentoEntity.id = p.id AND               x.planejamentoEntity.versao = p.versao) = \t   ( SELECT COUNT(x)         FROM EmpacotamentoEntity x  \t     WHERE x.sistemaEntity.id = p.sistemaEntity.id AND               x.usuarioEntity.login = :login AND               x.versao = p.versao AND               x.commit = :sim AND               x.fim IS NULL)");
        query.setParameter("sim", (Object)true);
        query.setParameter("login", (Object)login);
        List lista = CollectionUtils.transform(PlanejamentoEntity.class, (Collection)query.getResultList());
        TreeSet<PlanejamentoEntity> listaRetorno = new TreeSet<PlanejamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<PlanejamentoEntity> listPlanejadoNaoVersionado() {
        TypedQuery query = this.getEntityManager().createQuery("SELECT p FROM PlanejamentoEntity p   JOIN FETCH p.listaSol ls   JOIN FETCH p.sistemaEntity a   JOIN FETCH p.usuarioEntity u WHERE NOT EXISTS ( SELECT 0         \t\t\tFROM VersionamentoEntity x  \t     \t\t\tWHERE x.sistemaEntity = a AND               \t\t\t  x.versao = p.versao AND                          x.status != :status)   AND NOT EXISTS (SELECT 0                   FROM AceiteEntity x  \t     \t\t\tWHERE x.sistemaEntity = a AND               \t\t\t  x.versao = p.versao AND                          x.status = :statusBloqueado) ", PlanejamentoEntity.class);
        query.setParameter("status", (Object)StatusType.DESCARTADO);
        query.setParameter("statusBloqueado", (Object)StatusType.BLOQUEADO);
        List lista = query.getResultList();
        TreeSet<PlanejamentoEntity> listaRetorno = new TreeSet<PlanejamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public List<PlanejamentoSolEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PlanejamentoSolEntity.class);
        Root root = criteria.from(PlanejamentoSolEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("planejamentoEntity").join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public PlanejamentoEntity pesquisa(String cliente, String sistema, TecnologiaType tecnologia, String pacote) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PlanejamentoEntity.class);
        Root root = criteria.from(PlanejamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereCliente = builder.equal((Expression)root.join("sistemaEntity").get("cliente"), (Object)cliente);
        Predicate whereSistema = builder.equal((Expression)root.join("sistemaEntity").get("sistema"), (Object)sistema);
        Predicate whereTecnologia = builder.equal((Expression)root.join("sistemaEntity").get("tecnologia"), (Object)tecnologia);
        Predicate wherePacote = builder.equal((Expression)root.get("versao"), (Object)pacote);
        criteria.where(new Predicate[]{whereCliente, whereSistema, whereTecnologia, wherePacote});
        return (PlanejamentoEntity)this.getEntityManager().createQuery(criteria).getSingleResult();
    }

    @Override
    public PlanejamentoEntity pesquisaPlanejamentoParaVersionar(String cliente, String sistema, TecnologiaType tecnologia, String versao) {
        String script = "SELECT p FROM PlanejamentoEntity p   JOIN FETCH p.listaSol ls WHERE p.versao = :versao   AND p.sistemaEntity.cliente = :cliente   AND p.sistemaEntity.sistema = :sistema   AND p.sistemaEntity.tecnologia = :tecnologia ";
        TypedQuery query = this.getEntityManager().createQuery(script, PlanejamentoEntity.class);
        query.setParameter("versao", (Object)versao);
        query.setParameter("cliente", (Object)cliente);
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("tecnologia", (Object)tecnologia);
        return (PlanejamentoEntity)query.getSingleResult();
    }
}

