/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.parametro;

import br.com.dsfnet.gpd.client.parametro.ParametroEntity;
import br.com.dsfnet.gpd.client.parametro.ParametroRepository;
import br.com.jarch.core.crud.dao.CrudDao;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.Map;

public class ParametroDao
extends CrudDao<ParametroEntity>
implements ParametroRepository {
    private final Map<String, String> mapaDados = new HashMap<String, String>();

    @Override
    @Transactional
    public String pesquisaChave(String chave, String padrao) {
        String conteudo = this.mapaDados.get(chave);
        if (conteudo != null) {
            return conteudo;
        }
        try {
            CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(ParametroEntity.class);
            Root root = criteria.from(ParametroEntity.class);
            criteria.select((Selection)root);
            Predicate whereChave = builder.equal((Expression)root.get("chave"), (Object)chave);
            criteria.where((Expression)whereChave);
            ParametroEntity parametro = (ParametroEntity)((Object)this.getEntityManager().createQuery(criteria).getSingleResult());
            if (parametro == null) {
                throw new Exception();
            }
            this.mapaDados.put(chave, parametro.getConteudo());
            return parametro.getConteudo();
        }
        catch (Exception ex) {
            ParametroEntity parametro = new ParametroEntity();
            parametro.setChave(chave);
            parametro.setConteudo(padrao);
            this.getEntityManager().persist((Object)parametro);
            return this.pesquisaChave(chave, padrao);
        }
    }

    @Override
    public String pesquisaChave(String chave) {
        return this.pesquisaChave(chave, "");
    }
}

