/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.empacotamento;

import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoHistoricoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoHistoricoRepository;
import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;

@JArchDao
public class EmpacotamentoHistoricoDao
extends CrudDao<EmpacotamentoHistoricoEntity>
implements EmpacotamentoHistoricoRepository {
    @Override
    @Transactional
    public void inicia(SistemaEntity sistemaEntity, UsuarioEntity usuarioEntity, String versao, Date dataInicial) throws EmpacotamentoException {
        try {
            this.fecha(sistemaEntity, usuarioEntity, versao, new Date());
            EmpacotamentoHistoricoEntity empacotamentoHistoricoEntity = new EmpacotamentoHistoricoEntity();
            empacotamentoHistoricoEntity.setSistemaEntity(sistemaEntity);
            empacotamentoHistoricoEntity.setUsuarioEntity(usuarioEntity);
            empacotamentoHistoricoEntity.setVersao(versao);
            empacotamentoHistoricoEntity.setDataInicial(dataInicial);
            this.getEntityManager().merge((Object)empacotamentoHistoricoEntity);
        }
        catch (Exception ex) {
            throw new EmpacotamentoException(ex.getMessage());
        }
    }

    @Override
    @Transactional
    public void fecha(SistemaEntity sistemaEntity, UsuarioEntity usuarioEntity, String versao, Date dataFinal) throws EmpacotamentoException {
        for (EmpacotamentoHistoricoEntity entity : this.pesquisaEmpacotamentoAberto(sistemaEntity, usuarioEntity, versao)) {
            try {
                entity.setSistemaEntity(sistemaEntity);
                entity.setUsuarioEntity(usuarioEntity);
                entity.setVersao(versao);
                entity.setDataFinal(dataFinal);
                this.getEntityManager().merge((Object)entity);
            }
            catch (Exception ex) {
                throw new EmpacotamentoException(ex.getMessage());
            }
        }
    }

    @Override
    public Collection<EmpacotamentoHistoricoEntity> pesquisaEmpacotamentoAberto(SistemaEntity sistemaEntity, UsuarioEntity usuarioEntity, String versao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoHistoricoEntity.class);
        Root root = criteria.from(EmpacotamentoHistoricoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)sistemaEntity.getId());
        Predicate whereUsuario = builder.equal((Expression)root.join("usuarioEntity").get("id"), (Object)usuarioEntity.getId());
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        Predicate whereDataFinal = builder.isNull((Expression)root.get("dataFinal"));
        criteria.where(new Predicate[]{whereAplicacao, whereUsuario, whereVersao, whereDataFinal});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

