/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.empacotamento;

import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoHistoricoRepository;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoRepository;
import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.form.EmpacotamentoForm;
import br.com.dsfnet.gpd.client.pacote.PacoteRepository;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.dsfnet.gpd.client.util.DataHoraUtils;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.ejb.AccessTimeout;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class EmpacotamentoDao
extends CrudDao<EmpacotamentoEntity>
implements EmpacotamentoRepository {
    @Override
    public EmpacotamentoEntity pesquisaEmpacotamento(PlanejamentoEntity planejamento) {
        Collection<EmpacotamentoEntity> lista = this.pesquisaVersao(planejamento.getSistemaEntity().getId(), planejamento.getVersao());
        Optional<EmpacotamentoEntity> findAny = lista.stream().findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return null;
    }

    @Override
    @Transactional
    public EmpacotamentoEntity iniciarEmpacotamento(PlanejamentoSolEntity planejamentoSol, String login) {
        EmpacotamentoEntity empacotamentoEntity;
        UsuarioEntity usuarioEntity = null;
        try {
            usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(login);
            empacotamentoEntity = this.pesquisaVersaoSemSol(planejamentoSol.getPlanejamentoEntity().getSistemaEntity().getId(), planejamentoSol.getPlanejamentoEntity().getVersao());
            empacotamentoEntity.setNumeroSol(planejamentoSol.getNumeroSol());
            this.getEntityManager().persist((Object)empacotamentoEntity);
        }
        catch (Exception ex) {
            empacotamentoEntity = new EmpacotamentoEntity();
            empacotamentoEntity.setNumeroSol(planejamentoSol.getNumeroSol());
            empacotamentoEntity.setVersao(planejamentoSol.getPlanejamentoEntity().getVersao());
            empacotamentoEntity.setSistemaEntity(planejamentoSol.getPlanejamentoEntity().getSistemaEntity());
            empacotamentoEntity.setInicio(new Date());
            empacotamentoEntity.setUsuarioEntity(usuarioEntity);
            this.getEntityManager().persist((Object)empacotamentoEntity);
        }
        return empacotamentoEntity;
    }

    @Override
    @Transactional
    public EmpacotamentoEntity iniciarPlanejamento(PlanejamentoEntity planejamento, String login) throws EmpacotamentoException {
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        EmpacotamentoEntity empacotamento = new EmpacotamentoEntity();
        empacotamento.setVersao(planejamento.getVersao());
        empacotamento.setSistemaEntity(planejamento.getSistemaEntity());
        empacotamento.setInicio(new Date());
        empacotamento.setUsuarioEntity(usuario);
        this.getEntityManager().persist((Object)empacotamento);
        EmpacotamentoHistoricoRepository.getInstance().inicia(empacotamento.getSistemaEntity(), empacotamento.getUsuarioEntity(), empacotamento.getVersao(), empacotamento.getInicio());
        return empacotamento;
    }

    @Override
    @AccessTimeout(value=-1L)
    @Transactional
    public List<EmpacotamentoEntity> liberar(String login, String versao, Long aplicacaoId, String nomeArquivo, byte[] streamArquivo) throws PacoteException, EmpacotamentoException {
        SistemaEntity sistemaEntity = (SistemaEntity)SistemaRepository.getInstance().find(aplicacaoId);
        if (streamArquivo != null) {
            PacoteRepository.getInstance().gravar(sistemaEntity.getSistema(), sistemaEntity.getTecnologia(), sistemaEntity.getCliente(), versao, streamArquivo, nomeArquivo);
        }
        List<EmpacotamentoEntity> lista = this.abertos(versao, aplicacaoId);
        UsuarioEntity usuarioEntity = null;
        for (EmpacotamentoEntity empacotamentoEntity : lista) {
            empacotamentoEntity.setFim(new Date());
            this.getEntityManager().merge((Object)empacotamentoEntity);
            usuarioEntity = empacotamentoEntity.getUsuarioEntity();
        }
        EmpacotamentoHistoricoRepository.getInstance().fecha(sistemaEntity, usuarioEntity, versao, new Date());
        return lista;
    }

    @Override
    @Transactional
    public void apagar(String versao, Long aplicacaoId) {
        List<EmpacotamentoEntity> lista = this.pesquisar(aplicacaoId, versao);
        for (EmpacotamentoEntity andamentoEmpacotamentoEntity : lista) {
            this.getEntityManager().remove((Object)andamentoEmpacotamentoEntity);
        }
    }

    @Override
    @Transactional
    public void limparDataFim(String versao, Long aplicacaoId) {
        List<EmpacotamentoEntity> lista = this.pesquisar(aplicacaoId, versao);
        for (EmpacotamentoEntity andamentoEmpacotamentoEntity : lista) {
            andamentoEmpacotamentoEntity.setFim(null);
            this.getEntityManager().merge((Object)andamentoEmpacotamentoEntity);
        }
    }

    @Override
    @Transactional
    public void finalizarEmpacotamento(EmpacotamentoEntity empacotamento) throws EmpacotamentoException {
        try {
            EmpacotamentoEntity empacotamentoEntity = (EmpacotamentoEntity)this.find(empacotamento.getId());
            empacotamentoEntity.setCommit(true);
            this.getEntityManager().merge((Object)empacotamentoEntity);
        }
        catch (Exception ex) {
            throw new EmpacotamentoException(ex.getMessage());
        }
    }

    @Override
    public boolean existeSemCommit(String versao, Long aplicacaoId) {
        try {
            List<EmpacotamentoEntity> listaRetorno = this.semCommit(versao, aplicacaoId);
            return listaRetorno.size() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private List<EmpacotamentoEntity> semCommit(String versao, Long aplicacaoId) {
        Query query = this.getEntityManager().createQuery("SELECT ae FROM EmpacotamentoEntity ae WHERE ae.versao = :versao AND       ae.sistemaEntity.id = :aplicacaoId AND       ae.commit = :nao AND       ae.fim IS NULL AND       ae.numeroSol IS NOT NULL");
        query.setParameter("versao", (Object)versao);
        query.setParameter("aplicacaoId", (Object)aplicacaoId);
        query.setParameter("nao", (Object)false);
        return CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
    }

    @Override
    public EmpacotamentoEntity pesquisar(String versao) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM EmpacotamentoEntity ad WHERE ad.versao = :versao AND       NOT EXISTS( SELECT 0 \t\t\t\t   FROM EmpacotamentoEntity x                   WHERE x.versao = ad.versao AND                         x.id > ad.id)");
        query.setParameter("versao", (Object)versao);
        return (EmpacotamentoEntity)query.getSingleResult();
    }

    @Override
    public List<EmpacotamentoEntity> pesquisar(Long aplicacaoId, String versao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        criteria.where(new Predicate[]{whereAplicacao, whereVersao});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public EmpacotamentoEntity pesquisar(Long aplicacaoId, String versao, String numeroSol) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        criteria.where(new Predicate[]{whereAplicacao, whereVersao, whereNumeroSol});
        return (EmpacotamentoEntity)this.getEntityManager().createQuery(criteria).getSingleResult();
    }

    @Override
    public EmpacotamentoEntity pesquisarSemAceite(String versao) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM EmpacotamentoEntity ad WHERE ad.versao = :versao AND       (ad.aceite IS NULL OR ad.aceite = :nao) AND       NOT EXISTS( SELECT 0 \t\t\t\t   FROM EmpacotamentoEntity x                   WHERE x.versao = ad.versao AND       \t\t\t\t\t (x.aceite IS NULL OR x.aceite = :nao) AND                         x.id > ad.id)");
        query.setParameter("versao", (Object)versao);
        query.setParameter("nao", (Object)false);
        return (EmpacotamentoEntity)query.getSingleResult();
    }

    @Override
    public Set<String> listaVersaoSemCommit() {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM EmpacotamentoEntity ad WHERE ad.versao IS NOT NULL AND       ad.commit = :nao");
        query.setParameter("nao", (Object)false);
        List lista = CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
        TreeSet<String> listaRetorno = new TreeSet<String>();
        for (EmpacotamentoEntity andamentoEmpacotamentoEntity : lista) {
            listaRetorno.add(andamentoEmpacotamentoEntity.getVersao());
        }
        return listaRetorno;
    }

    @Override
    public Set<String> listaVersaoAberto() {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM EmpacotamentoEntity ad WHERE ad.versao IS NOT NULL AND       ad.fim IS NULL");
        List lista = CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
        TreeSet<String> listaRetorno = new TreeSet<String>();
        for (EmpacotamentoEntity andamentoEmpacotamentoEntity : lista) {
            listaRetorno.add(andamentoEmpacotamentoEntity.getVersao());
        }
        return listaRetorno;
    }

    private List<EmpacotamentoEntity> abertos(String versao, Long aplicacaoId) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM EmpacotamentoEntity ad WHERE ad.versao = :versao AND       ad.sistemaEntity.id = :aplicacaoId AND       ad.fim IS NULL");
        query.setParameter("versao", (Object)versao);
        query.setParameter("aplicacaoId", (Object)aplicacaoId);
        return CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
    }

    @Override
    public List<EmpacotamentoForm> listaVersaoServidor() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + EmpacotamentoForm.class.getName() + "(apl.sistema, apl.cliente, apl.tecnologia, p.versao, p.numeroSol, '', p.inicio, p.fim, usu.login) FROM EmpacotamentoEntity p JOIN p.sistemaEntity apl JOIN p.usuarioEntity usu WHERE       NOT EXISTS( SELECT 0                   FROM EmpacotamentoEntity x                   WHERE x.sistemaEntity.id = p.sistemaEntity.id AND                         x.numeroSol = p.numeroSol AND                         x.id > p.id) ORDER BY p.inicio DESC");
        List lista = CollectionUtils.transform(EmpacotamentoForm.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public EmpacotamentoEntity pesquisarNaoVersionado(String versao) {
        Query query = this.getEntityManager().createQuery("SELECT p FROM EmpacotamentoEntity p WHERE p.versao = :versao AND       NOT EXISTS( SELECT 0 \t\t\t\t   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = p.sistemaEntity.id AND                         x.versao = p.versao )");
        query.setParameter("versao", (Object)versao);
        return (EmpacotamentoEntity)query.getSingleResult();
    }

    @Override
    public List<EmpacotamentoEntity> listaNaoVersionado() {
        Query query = this.getEntityManager().createQuery("SELECT e FROM EmpacotamentoEntity e WHERE e.versao IS NOT NULL AND \t   e.fim IS NOT NULL AND       EXISTS( SELECT 0               FROM AceiteEntity x               WHERE x.sistemaEntity.id = e.sistemaEntity.id AND                     x.versao = e.versao AND                     x.fim IS NOT NULL AND                     x.fim > e.fim AND                     x.status = :liberado) AND       NOT EXISTS( SELECT 0                   FROM EmpacotamentoEntity x                   WHERE x.sistemaEntity.id = e.sistemaEntity.id AND                         x.versao = e.versao AND                         x.id > e.id) AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = e.sistemaEntity.id AND                         x.versao = e.versao AND \t\t\t\t\t\t x.status != :descartado) AND       NOT EXISTS( SELECT 0                   FROM AutorizacaoEntity x                   WHERE x.sistemaEntity.id = e.sistemaEntity.id AND                         x.versao = e.versao AND                         (x.autorizacao < :inicioDia OR x.autorizacao > :fimDia)) ORDER BY e.versao DESC");
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        query.setParameter("descartado", (Object)StatusType.DESCARTADO);
        query.setParameter("inicioDia", (Object)DataHoraUtils.inicioDia(new Date()));
        query.setParameter("fimDia", (Object)DataHoraUtils.fimDia(new Date()));
        List lista = CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
        return lista;
    }

    public EmpacotamentoEntity pesquisaVersaoSemSol(Long aplicacaoId, String versao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        Predicate whereSol = builder.isNull((Expression)root.get("numeroSol"));
        criteria.where(new Predicate[]{whereAplicacao, whereVersao, whereSol});
        EmpacotamentoEntity andamentoEmpacotamentoEntity = (EmpacotamentoEntity)this.getEntityManager().createQuery(criteria).getSingleResult();
        return andamentoEmpacotamentoEntity;
    }

    public Collection<EmpacotamentoEntity> pesquisaVersao(Long aplicacaoId, String versao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        criteria.where(new Predicate[]{whereAplicacao, whereVersao});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return lista;
    }

    @Override
    public Set<EmpacotamentoEntity> listaEmpacotamentoFinalizar(String login) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereSol = builder.isNotNull((Expression)root.get("numeroSol"));
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereCommit = builder.equal((Expression)root.get("commit"), (Object)false);
        Predicate whereLogin = builder.equal((Expression)root.get("usuarioEntity").get("login"), (Object)login);
        criteria.where(new Predicate[]{whereSol, whereFim, whereCommit, whereLogin});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<EmpacotamentoEntity> listaRetorno = new TreeSet<EmpacotamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<EmpacotamentoEntity> listaAceitePacote(AmbienteType ambiente) {
        Query query = this.getEntityManager().createQuery("SELECT d FROM EmpacotamentoEntity d JOIN FETCH d.usuarioEntity JOIN FETCH d.sistemaEntity WHERE d.versao IS NOT NULL AND       d.fim IS NOT NULL AND       NOT EXISTS( SELECT 0                   FROM EmpacotamentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.versao = d.versao AND                         x.id > d.id) AND       NOT EXISTS( SELECT 0                   FROM AceiteEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.versao = d.versao AND                         x.fim > d.fim AND                         x.ambiente = :ambiente AND                         x.status != :status)");
        query.setParameter("ambiente", (Object)ambiente);
        query.setParameter("status", (Object)StatusType.DESCARTADO);
        List lista = CollectionUtils.transform(EmpacotamentoEntity.class, (Collection)query.getResultList());
        TreeSet<EmpacotamentoEntity> listaRetorno = new TreeSet<EmpacotamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public boolean existeAbertoWorkingCopy(String workingCopy, String login) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.isNotNull((Expression)root.get("numeroSol"));
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("servidorEmpacotamento"), (Object)workingCopy);
        Predicate whereLogin = builder.equal((Expression)root.join("usuarioEntity").get("login"), (Object)login);
        criteria.where(new Predicate[]{whereNumeroSol, whereFim, whereAplicacao, whereLogin});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return !lista.isEmpty();
    }

    @Override
    public Set<EmpacotamentoEntity> listaSolEmpacotado(Long aplicacaoId, String versao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        criteria.where(new Predicate[]{whereAplicacao, whereVersao});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<EmpacotamentoEntity> listaRetorno = new TreeSet<EmpacotamentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public List<EmpacotamentoEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(EmpacotamentoEntity.class);
        Root root = criteria.from(EmpacotamentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.desc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

