/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz0t;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVS2;
import com.aspose.words.zzWGX;
import com.aspose.words.zzWmx;
import com.aspose.words.zzXem;
import com.aspose.words.zzYaH;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzVWW;
    private Node zzZhM;
    private Node zzWyf;
    private int zzZnv;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzYeh(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzVWW == null) {
            return null;
        }
        if (this.zzVWW.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzVWW;
    }

    final CompositeNode zzYNV() {
        if (zzWmx.zzXS6(this.getParentNode())) {
            return this.getParentNode().zzYNV();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZR2() {
        if (zzWmx.zzXS6(this.getParentNode()) || zzWmx.zzXcH(this.getParentNode())) {
            return this.getParentNode().zzZR2();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzVWW != null) {
            return this.zzVWW.getDocument();
        }
        return null;
    }

    final Document zzWKy() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZhW() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZOR();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzWyf;
    }

    final Node zzDZ() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzWmx.zzY1u((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzWL3() {
        Node node = zzWmx.zzZZc(this.getPreviousSibling(), false);
        if (node == null && zzWmx.zzXS6(this.getParentNode())) {
            node = this.getParentNode().zzWL3();
        }
        return node;
    }

    final Node zzYZK() {
        Node node = zzWmx.zzXxe(this.getNextSibling(), false);
        if (node == null && zzWmx.zzXS6(this.getParentNode())) {
            node = this.getParentNode().zzYZK();
        }
        return node;
    }

    final CompositeNode zzYve() {
        Node node = this;
        while ((node = node.zzWL3()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzX5() {
        Node node = this;
        while ((node = node.zzYZK()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZhM;
    }

    final Node zzZdn() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzWmx.zzY1u((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzbN() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYMb() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXlp() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzWmx.zzWRv(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYR9() {
        return this.zzZhM;
    }

    final void zzXoH(Node node) {
        this.zzZhM = node;
    }

    final Node zzZPQ() {
        return this.zzWyf;
    }

    final void zza6(Node node) {
        this.zzWyf = node;
    }

    final Node zzXVa() {
        Node node = this;
        if (node.zzZhM != null) {
            node = this;
            return node.zzZhM;
        }
        return this.getParentNode();
    }

    final int zzWVd() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzWmx.zzX91(this);
        boolean bl2 = zzWmx.zzW8N(this);
        boolean bl3 = zzWmx.zzWtl(this);
        boolean bl4 = zzWmx.zzWn(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzWVd() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzWVd() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXDP(isCloneChildren, new zzXDP(this));
    }

    Node zzXDP(boolean bl, zzVS2 zzVS22) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzVWW != null) {
            node.zzVWW = this.getDocument().zzZxT();
        }
        node.zzZhM = null;
        node.zzWyf = null;
        if (zzVS22 != null) {
            zzVS22.zzWOR(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzYgb(StringBuilder stringBuilder) {
        zzZwy.zzYMQ(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWOw(Node node) {
        this.zzVWW = node != null ? node : this.getDocument().zzZxT();
    }

    final void zzYeh(DocumentBase documentBase) {
        this.zzVWW = documentBase != null ? documentBase.zzZxT() : null;
    }

    final boolean zzWdL(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYww() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWcG(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZOb(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzcs(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzYgb(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzJK(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzXem zzXem2 = zzWmx.zzZ7M(saveFormat);
        return zzXem2.zzVR6(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzXem zzXem2 = zzWmx.zzYMQ(saveOptions);
        return zzXem2.zzVR6(this);
    }

    final Node zzZln(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzWmx.zzVSI(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzWGX zzYbc() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzWGX.zzZVK(node);
        }
        return zzWGX.zzWnz(this.getParentNode());
    }

    final zzWGX zzXrh() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzWGX.zzWnz(node);
        }
        return zzWGX.zzZVK(this.getParentNode());
    }

    final boolean zz9i(Node node) {
        return Node.zzX4Y(this, node);
    }

    final boolean zzY3r() {
        return this.getAncestor(1) == null;
    }

    static Node zzTN(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zz0t<Node> zz0t2 = Node.zzYPC(node);
        zz0t<Node> zz0t3 = Node.zzYPC(node2);
        return Node.zzXDP(zz0t2, zz0t3);
    }

    static boolean zzX4Y(Node node, Node node2) {
        zz0t<Node> zz0t2;
        if (node == null || node2 == null) {
            return false;
        }
        zz0t<Node> zz0t3 = Node.zzYPC(node);
        Node node3 = Node.zzXDP(zz0t3, zz0t2 = Node.zzYPC(node2));
        if (node3 == null) {
            return false;
        }
        zz0t<Node> zz0t4 = zz0t3;
        if (zz0t4.size() == 0 || (zz0t4 = zz0t2).size() == 0) {
            zz0t4 = zz0t2;
            boolean bl = zz0t4.size() > 0;
            return bl;
        }
        Object e = zz0t3.peek();
        Object e2 = zz0t2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zz0t<Node> zzYPC(Node node) {
        zz0t<Node> zz0t2 = new zz0t<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz0t2.push(node2);
        }
        return zz0t2;
    }

    private static Node zzXDP(zz0t<Node> zz0t2, zz0t<Node> zz0t3) {
        Node node = null;
        while (zz0t2.peek() == zz0t3.peek()) {
            node = (Node)zz0t2.pop();
            zz0t3.pop();
            zz0t<Node> zz0t4 = zz0t2;
            if (zz0t4.size() != 0 && (zz0t4 = zz0t3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZnv;
    }

    public void setCustomNodeId(int value) {
        this.zzZnv = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzVSI(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWn(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzW8N(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWn(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWn(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXDP
    implements zzVS2 {
        private Node zzW1z;
        private HashMap<Integer, Integer> zzns;

        zzXDP(Node node) {
            this.zzW1z = node;
        }

        @Override
        public final void zzWOR(Node node, Node node2) {
            if (node == this.zzW1z) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzYaH zzYaH2 = (zzYaH)((Object)node2);
            if (this.zzns == null) {
                this.zzns = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZwy.zzXDP(this.zzns, Integer.valueOf(zzYaH2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzwT();
                zzZwy.zzYMQ(this.zzns, Integer.valueOf(zzYaH2.getIdInternal()), Integer.valueOf(n));
            }
            zzYaH2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZwy.zzXDP(this.zzns, Integer.valueOf(zzYaH2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzYaH2.setParentIdInternal(n2);
            }
        }
    }
}

