/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectFieldsStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWCDbSelectMovedForDelete
extends SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields> {
    private InternalStatement internalStatement;

    public SVNWCDbSelectMovedForDelete(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
    }

    @Override
    protected void defineFields() {
        this.fields.add(SVNWCDbSchema.NODES__Fields.local_relpath);
        this.fields.add(SVNWCDbSchema.NODES__Fields.moved_to);
        this.fields.add(SVNWCDbSchema.NODES__Fields.op_depth);
    }

    @Override
    public void reset() throws SVNException {
        if (this.internalStatement != null) {
            this.internalStatement.reset();
            this.internalStatement = null;
        }
        super.reset();
    }

    @Override
    protected String getPathScope() {
        return (String)this.getBind(2);
    }

    @Override
    protected boolean isStrictiDescendant() {
        return false;
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        long opDepth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
        if (this.internalStatement == null) {
            this.internalStatement = new InternalStatement(this.sDb);
            this.internalStatement.bindf("isi", this.getBind(1), this.getBind(2), opDepth);
            this.internalStatement.next();
        }
        return !this.isColumnNull(SVNWCDbSchema.NODES__Fields.moved_to) && opDepth >= (Long)this.getBind(3);
    }

    @Override
    protected Object[] getWhere() throws SVNException {
        return new Object[]{this.getBind(1)};
    }

    public int getMovedHereDepth() throws SVNException {
        if (this.internalStatement == null) {
            return -1;
        }
        return (int)this.internalStatement.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
    }

    private static class InternalStatement
    extends SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields> {
        public InternalStatement(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES);
        }

        @Override
        protected void defineFields() {
            this.fields.add(SVNWCDbSchema.NODES__Fields.op_depth);
        }

        @Override
        protected ISqlJetCursor openCursor() throws SVNException {
            try {
                ISqlJetCursor cursor = super.openCursor().reverse();
                cursor.setLimit(1L);
                return cursor;
            }
            catch (SqlJetException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
                return null;
            }
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) < (Long)this.getBind(3) && !this.isColumnNull(SVNWCDbSchema.NODES__Fields.moved_here);
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            return new Object[]{this.getBind(1), this.getBind(2)};
        }
    }
}

