/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

public class Spacer {
    private static final ReentrantLock lock = new ReentrantLock();
    private static char[] spaces = new char[]{' '};
    private int n;

    public Spacer() {
        this(0);
    }

    public Spacer(int n) {
        this.n = n;
    }

    public Spacer set(int n) {
        this.n = n;
        return this;
    }

    public int get() {
        return this.n;
    }

    public Spacer add(int n) {
        this.n += n;
        return this;
    }

    public Spacer subtract(int n) {
        this.n -= n;
        return this;
    }

    public String toString() {
        return new String(Spacer.getSpaces(this.n), 0, this.n);
    }

    public StringBuilder spaces(StringBuilder buf) {
        buf.append(Spacer.getSpaces(this.n), 0, this.n);
        return buf;
    }

    public Writer spaces(Writer buf) throws IOException {
        buf.write(Spacer.getSpaces(this.n), 0, this.n);
        return buf;
    }

    public StringWriter spaces(StringWriter buf) {
        buf.write(Spacer.getSpaces(this.n), 0, this.n);
        return buf;
    }

    public PrintWriter spaces(PrintWriter buf) {
        buf.write(Spacer.getSpaces(this.n), 0, this.n);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] getSpaces(int n) {
        lock.lock();
        try {
            if (spaces.length < n) {
                spaces = new char[n];
                Arrays.fill(spaces, ' ');
            }
            char[] cArray = spaces;
            return cArray;
        }
        finally {
            lock.unlock();
        }
    }
}

