/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleBlob;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public interface BlobDBAccess
extends Monitor {
    public long length(OracleBlob var1) throws SQLException;

    public CompletionStage<Long> lengthAsync(OracleBlob var1);

    public long position(OracleBlob var1, Datum var2, byte[] var3, long var4) throws SQLException;

    public long position(OracleBlob var1, Datum var2, Datum var3, long var4) throws SQLException;

    public int getBytes(OracleBlob var1, long var2, int var4, byte[] var5) throws SQLException;

    default public boolean isAsyncBlobGetSupported() {
        return false;
    }

    default public CompletionStage<Integer> getBytesAsync(OracleBlob blob, long pos, int length, byte[] buf, ErrorSet continueOnErrorSet) {
        return CompletableFuture.failedStage(new SQLFeatureNotSupportedException());
    }

    public int putBytes(OracleBlob var1, long var2, byte[] var4, int var5, int var6) throws SQLException;

    default public boolean isAsyncBlobPutSupported() {
        return false;
    }

    default public CompletionStage<Integer> putBytesAsync(OracleBlob blob, long pos, byte[] bytes, int offset, int length, ErrorSet continueOnErrorSet) {
        return CompletableFuture.failedStage(new SQLFeatureNotSupportedException());
    }

    public int getChunkSize(OracleBlob var1) throws SQLException;

    default public void getChunkSizeAsync(OracleBlob blob, BiConsumer<Integer, Throwable> callback) {
        callback.accept(null, new SQLFeatureNotSupportedException());
    }

    public void trim(OracleBlob var1, long var2) throws SQLException;

    public BLOB createTemporaryBlob(Connection var1, boolean var2, int var3) throws SQLException;

    public void freeTemporary(OracleBlob var1, Datum var2, boolean var3) throws SQLException;

    public boolean isTemporary(OracleBlob var1) throws SQLException;

    public short getDuration(OracleBlob var1) throws SQLException;

    public void open(OracleBlob var1, int var2) throws SQLException;

    public void close(OracleBlob var1) throws SQLException;

    public CompletionStage<Void> closeAsync(OracleBlob var1);

    public boolean isOpen(OracleBlob var1) throws SQLException;

    default public CompletionStage<Boolean> isOpenAsync(OracleBlob lob) {
        return CompletableFuture.failedStage(new SQLFeatureNotSupportedException());
    }

    public InputStream newInputStream(OracleBlob var1, int var2, long var3) throws SQLException;

    public InputStream newInputStream(OracleBlob var1, int var2, long var3, long var5) throws SQLException;

    public InputStream newInputStream(OracleBlob var1, int var2, long var3, boolean var5) throws SQLException;

    public InputStream newInputStream(OracleBlob var1, int var2, long var3, long var5, boolean var7) throws SQLException;

    public OutputStream newOutputStream(OracleBlob var1, int var2, long var3, boolean var5) throws SQLException;

    public InputStream newConversionInputStream(OracleBlob var1, int var2, boolean var3) throws SQLException;

    public Reader newConversionReader(OracleBlob var1, int var2, boolean var3) throws SQLException;

    public void incrementTempLobReferenceCount(byte[] var1) throws SQLException;

    public int decrementTempLobReferenceCount(byte[] var1) throws SQLException;
}

