/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.MessageDigest;
import java.sql.SQLException;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.sql.CharacterSet;

class ReadOnlyByteArray
extends ByteArray {
    private ByteArray array;

    static ByteArray newReadOnlyByteArray(Diagnosable diagnosable, ByteArray a) {
        if (a instanceof ReadOnlyByteArray) {
            return a;
        }
        return new ReadOnlyByteArray(diagnosable, a);
    }

    private ReadOnlyByteArray(Diagnosable diagnosable, ByteArray a) {
        super(diagnosable);
        this.array = a;
    }

    @Override
    long getCapacity() {
        return this.array.getCapacity();
    }

    @Override
    long length() {
        return this.array.length();
    }

    @Override
    void put(long index, byte value) {
        assert (false) : "attempt to modify a read-only byte array";
    }

    @Override
    byte get(long index) {
        return this.array.get(index);
    }

    @Override
    void put(long offset, byte[] src, int srcOffset, int length) {
        assert (false) : "attempt to modify a read-only byte array";
    }

    @Override
    void get(long offset, byte[] dest, int destOffset, int length) {
        this.array.get(offset, dest, destOffset, length);
    }

    @Override
    char[] getChars(long offset, int lengthInBytes, CharacterSet charSet, int[] out_lengthInChars) throws SQLException {
        return this.array.getChars(offset, lengthInBytes, charSet, out_lengthInChars);
    }

    @Override
    long updateChecksum(long offset, int length, CRC64 crc, long checksum) {
        return this.array.updateChecksum(offset, length, crc, checksum);
    }

    @Override
    void updateDigest(MessageDigest md, long valOffset, int valLen) {
        this.array.updateDigest(md, valOffset, valLen);
    }

    @Override
    void free() {
    }

    void deepFree() {
        this.array.free();
        this.array = null;
    }
}

