/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.OperationSystemUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public final class TerminalUtils {
    private TerminalUtils() {
    }

    public static int execute(String command) {
        return TerminalUtils.execute(command, null);
    }

    public static int execute(String command, List<String> log) {
        return TerminalUtils.execute(List.of(command), log);
    }

    public static int execute(List<String> commands) {
        return TerminalUtils.execute(commands, null);
    }

    public static int execute(List<String> commands, List<String> log) {
        int result = -1;
        try {
            ArrayList<String> commandsExecute = new ArrayList<String>();
            if (OperationSystemUtils.isWindows()) {
                commandsExecute.add("cmd");
                commandsExecute.add("/C");
            } else {
                commandsExecute.add("/bin/bash");
                commandsExecute.add("-c");
            }
            commandsExecute.add(String.join((CharSequence)"; ", commands));
            LogUtils.generate(String.join((CharSequence)" ", commandsExecute));
            ProcessBuilder p = new ProcessBuilder(commandsExecute);
            Process process = p.start();
            try (InputStream is = process.getInputStream();
                 InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    LogUtils.generate(line);
                    if (log == null) continue;
                    log.add(line);
                }
                process.waitFor();
                result = process.exitValue();
            }
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        return result;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
    }
}

