/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ProgressScpMonitor;
import br.com.jarch.util.SleepUtils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class SshUtils {
    private static final int TIMEOUT_CONNECTION = 3000;
    private static Map<String, Map<String, String>> connectionsSuccess;

    private SshUtils() {
    }

    public static boolean executeCommand(String host, int port, String user, String password, String command, OutputStream outputStreamSsh) {
        return SshUtils.executeCommand(host, port, user, password, List.of(command), outputStreamSsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeCommand(String host, int port, String user, String password, List<String> commands, OutputStream outputStreamSsh) {
        ChannelExec channel = null;
        Session session = null;
        boolean sucesso = false;
        try {
            session = SshUtils.createSession(host, port, user, password, outputStreamSsh);
            commands.forEach(c -> SshUtils.addOutputStream(c, outputStreamSsh));
            String commandAll = String.join((CharSequence)";\n", commands);
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(commandAll);
            channel.setErrStream((OutputStream)System.err);
            channel.setOutputStream(outputStreamSsh);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    String message = new String(tmp, 0, i);
                    SshUtils.addOutputStream(message, outputStreamSsh);
                    continue;
                }
                if (channel.isClosed()) {
                    if (channel.getExitStatus() == 0) break;
                    SshUtils.addOutputStream("ERROR !!! COMMAND: " + commandAll, outputStreamSsh);
                    break;
                }
                try {
                    SleepUtils.pauseSeconds(1);
                }
                catch (Exception ex) {
                    LogUtils.generate(ex);
                }
            }
            channel.disconnect();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            SshUtils.addOutputStream(ex.getMessage(), outputStreamSsh);
            sucesso = false;
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
        return sucesso;
    }

    public static void scp(String host, int port, String user, String password, String copyFrom, String copyTo, OutputStream outputStreamSsh) {
        Session session = null;
        Channel channel = null;
        try {
            session = SshUtils.createSession(host, port, user, password, outputStreamSsh);
            channel = session.openChannel("sftp");
            channel.setOutputStream(outputStreamSsh);
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            SshUtils.addOutputStream("scp -P " + port + " " + copyFrom + " " + user + "@" + host + ":" + copyTo, outputStreamSsh);
            SshUtils.copyLocalToRemote(sftp, copyFrom, copyTo, outputStreamSsh);
        }
        catch (Exception ex) {
            SshUtils.addOutputStream(ex.getMessage(), outputStreamSsh);
            throw new RuntimeException(ex.getMessage());
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsFile(String host, int port, String user, String password, String file, OutputStream outputStreamSsh) {
        Session session = null;
        Channel channel = null;
        try {
            session = SshUtils.createSession(host, port, user, password, outputStreamSsh);
            channel = session.openChannel("sftp");
            channel.setOutputStream(outputStreamSsh);
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            Vector result = sftp.ls(file);
            boolean bl = result != null && !result.isEmpty();
            return bl;
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFile(String host, int port, String user, String password, String file, OutputStream outputStreamSsh) {
        Session session = null;
        Channel channel = null;
        try {
            session = SshUtils.createSession(host, port, user, password, outputStreamSsh);
            channel = session.openChannel("sftp");
            channel.setOutputStream(outputStreamSsh);
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            sftp.rm(file);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private static void copyLocalToRemote(ChannelSftp sftp, String source, String dest, OutputStream outputStreamSsh) throws Exception {
        File sourceFile = new File(source);
        if (sourceFile.isFile()) {
            ProgressScpMonitor myProgressMonitor = new ProgressScpMonitor(sftp.getSession().getHost(), outputStreamSsh);
            SshUtils.addOutputStream("scp from: " + source + " to: " + dest + File.separator + sourceFile.getName(), outputStreamSsh);
            sftp.cd(dest);
            sftp.put(source, sourceFile.getName(), (SftpProgressMonitor)myProgressMonitor);
        } else {
            File[] files = sourceFile.listFiles();
            if (files != null && !sourceFile.isHidden()) {
                try {
                    sftp.cd(dest + File.separator + sourceFile.getName());
                }
                catch (SftpException e) {
                    sftp.mkdir(dest + File.separator + sourceFile.getName());
                }
                for (File f : files) {
                    SshUtils.copyLocalToRemote(sftp, f.getAbsolutePath(), dest + File.separator + sourceFile.getName(), outputStreamSsh);
                }
            }
        }
    }

    public static boolean isLoginValid(String host, int port, String user, String password, OutputStream outputStreamSsh) {
        return SshUtils.isConnectionSuccess(host, port, user, password, outputStreamSsh);
    }

    public static boolean isConnectionSuccess(String host, int port, String user, String password, OutputStream outputStreamSsh) {
        try {
            Session session = SshUtils.createSession(host, port, user, password, 3000, outputStreamSsh);
            return session.isConnected();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return false;
        }
    }

    private static Session createSession(String host, int port, String user, String password, OutputStream outputStreamSsh) throws JSchException {
        return SshUtils.createSession(host, port, user, password, 3000, outputStreamSsh);
    }

    private static Session createSession(String host, int port, String user, String password, int timeout, OutputStream outputStreamSsh) throws JSchException {
        return SshUtils.createSessionPassword(host, port, user, password, timeout, outputStreamSsh);
    }

    private static Session createSessionPassword(String host, int port, String user, String password, int timeout, OutputStream outputStreamSsh) throws JSchException {
        for (int i = -1; i < 4; ++i) {
            if (i == -1 && (connectionsSuccess == null || connectionsSuccess.get(host) == null)) continue;
            JSch jSch = new JSch();
            if (i == -1) {
                user = connectionsSuccess.get(host).get("user");
            }
            Session session = jSch.getSession(user, host, port);
            if (i == -1) {
                password = connectionsSuccess.get(host).get("password");
            } else if (i == 1) {
                password = "J2s5s_Cr3st4@";
            } else if (i == 2) {
                password = "j2s5s_cr3st4@";
            } else if (i == 3) {
                password = "j2S5s_cR3st4@";
            }
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setTimeout(timeout);
            session.setOutputStream(outputStreamSsh);
            try {
                session.connect();
                if (connectionsSuccess == null) {
                    connectionsSuccess = new HashMap<String, Map<String, String>>();
                }
                connectionsSuccess.computeIfAbsent(host, k -> new HashMap());
                connectionsSuccess.get(host).put("user", user);
                connectionsSuccess.get(host).put("password", password);
                return session;
            }
            catch (Exception ex) {
                LogUtils.generate(ex);
                SshUtils.addOutputStream(ex.getMessage(), outputStreamSsh);
            }
        }
        throw new RuntimeException("Erro na autentica\u00e7\u00e3o do Servidor: " + host);
    }

    static void addOutputStream(String value, OutputStream outputStreamSsh) {
        try {
            LogUtils.generate(value);
            String valueWithoutPassord = value.replaceAll("(?i)password[:\\s]+\\S+", "password **********").concat("\n");
            outputStreamSsh.write(valueWithoutPassord.getBytes());
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    static void addProgress(String value, OutputStream outputStreamSsh) {
        try {
            LogUtils.generate(value);
            String valueWithoutPassord = value.replaceAll("(?i)password[:\\s]+\\S+", "password **********").concat("\n");
            outputStreamSsh.write(valueWithoutPassord.getBytes());
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    public static void main(String[] args) {
        ByteArrayOutputStream outputStreamSsh = new ByteArrayOutputStream();
        SshUtils.scp("10.103.1.30", 22, "wagner.araujo", "J2s5s_Cr3st4@", "/home/wagner/Dropbox/Wagner/Video", "/tmp/wagner/", outputStreamSsh);
    }
}

