/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.type.OperationSystemType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public final class OperationSystemUtils {
    private OperationSystemUtils() {
    }

    public static boolean isLinux() {
        return OperationSystemUtils.getOperationSystem() == OperationSystemType.LINUX;
    }

    public static boolean isWindows() {
        return OperationSystemUtils.getOperationSystem() == OperationSystemType.WINDOWS;
    }

    public static boolean isMac() {
        return OperationSystemUtils.getOperationSystem() == OperationSystemType.MAC;
    }

    public static String computerName() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostName();
    }

    public static String hostAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostAddress();
    }

    public static OperationSystemType getOperationSystem() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
            return OperationSystemType.WINDOWS;
        }
        if (osName.toLowerCase(Locale.ENGLISH).contains("linux")) {
            return OperationSystemType.LINUX;
        }
        return OperationSystemType.MAC;
    }

    public static boolean isEnviromentWesa() {
        try {
            return OperationSystemUtils.computerName().equals("wagner-pc") || OperationSystemUtils.computerName().equals("wagner-note");
        }
        catch (UnknownHostException e) {
            LogUtils.generate(e);
            return false;
        }
    }
}

