/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.exception.CloneBeanException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public final class CloneBeanUtils {
    private CloneBeanUtils() {
    }

    public static <T> void clone(T source, T target) {
        try {
            BeanUtils.copyProperties(target, source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void cloneBean(Object bean, Object cloneBean) {
        CloneBeanUtils.cloneBean(cloneBean, cloneBean, bean);
    }

    @Deprecated
    public static Object cloneBean(Class<?> classe, Object bean) {
        try {
            Object cloneBean = classe.cast(BeanUtils.cloneBean((Object)bean));
            return classe.cast(CloneBeanUtils.cloneBean(cloneBean, cloneBean, bean));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new CloneBeanException(ex);
        }
    }

    private static Object cloneBean(Object object, Object cloneOriginalBean, Object originalBean) {
        try {
            Object cloneBean = object.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            Object bean = CloneBeanUtils.retornarObjeto(object);
            Map describe = BeanUtils.describe((Object)bean);
            for (Map.Entry entry : describe.entrySet()) {
                Object propertyValue = PropertyUtils.getProperty((Object)bean, (String)entry.getKey().toString());
                if (propertyValue == null || propertyValue.getClass().isAssignableFrom(Class.class) || !PropertyUtils.isWriteable(cloneBean, (String)entry.getKey().toString())) continue;
                CloneBeanUtils.setProperty(cloneOriginalBean, originalBean, cloneBean, entry, propertyValue);
            }
            return cloneBean;
        }
        catch (Exception ex) {
            throw new CloneBeanException(ex);
        }
    }

    private static void setProperty(Object cloneOriginalBean, Object originalBean, Object cloneBean, Map.Entry<?, ?> entry, Object propertyValue) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (CloneBeanUtils.isPrimitiveWrapper(propertyValue) || CloneBeanUtils.isByteArrayTimestampString(propertyValue) || propertyValue.getClass().isEnum() || propertyValue instanceof Collection) {
            PropertyUtils.setProperty((Object)cloneBean, (String)((String)entry.getKey()), (Object)propertyValue);
        } else if (propertyValue.equals(originalBean)) {
            PropertyUtils.setProperty((Object)cloneBean, (String)((String)entry.getKey()), (Object)cloneOriginalBean);
        } else {
            Object nestedCloneBean = CloneBeanUtils.cloneBean(propertyValue, cloneBean, originalBean);
            PropertyUtils.setProperty((Object)cloneBean, (String)((String)entry.getKey()), (Object)nestedCloneBean);
        }
    }

    private static boolean isByteArrayTimestampString(Object propertyValue) {
        return propertyValue.getClass().isAssignableFrom(byte[].class) || propertyValue.getClass().isAssignableFrom(Date.class) || propertyValue.getClass().isAssignableFrom(String.class);
    }

    private static Object retornarObjeto(Object objeto) {
        if (objeto == null) {
            return null;
        }
        for (int i = 0; i < objeto.getClass().getDeclaredFields().length; ++i) {
            Field field = objeto.getClass().getDeclaredFields()[i];
            if (!field.getType().isAssignableFrom(List.class)) continue;
            try {
                Method metodo = CloneBeanUtils.metodoGet(objeto, field.getName());
                metodo.invoke(objeto, new Object[0]);
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                boolean campoAcessivel = true;
                if (!field.canAccess(objeto)) {
                    field.setAccessible(true);
                    campoAcessivel = false;
                }
                CloneBeanUtils.setValueField(objeto, field);
                if (campoAcessivel) continue;
                field.setAccessible(false);
            }
        }
        return objeto;
    }

    private static void setValueField(Object objeto, Field field) {
        try {
            if (field.getType() == List.class) {
                field.set(objeto, new ArrayList());
            } else if (field.getType() == Set.class) {
                field.set(objeto, new TreeSet());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static Method metodoGet(Object objeto, String campo) throws NoSuchMethodException {
        String methodName = "get" + Character.toUpperCase(campo.charAt(0)) + campo.substring(1);
        return objeto.getClass().getMethod(methodName, new Class[0]);
    }

    private static boolean isPrimitiveWrapper(Object propertyValue) {
        return Character.class.isAssignableFrom(propertyValue.getClass()) || Number.class.isAssignableFrom(propertyValue.getClass()) || byte[].class.isAssignableFrom(propertyValue.getClass()) || Boolean.class.isAssignableFrom(propertyValue.getClass());
    }

    public static String createToStringFor(Object obj) {
        Field[] fields;
        StringBuilder sb = new StringBuilder(obj.getClass().getSimpleName() + ": [");
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            sb.append(field.getName()).append(": ");
            field.setAccessible(true);
            try {
                sb.append(field.get(obj)).append(", ");
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                sb.append(" , ");
            }
            field.setAccessible(false);
        }
        String aRetornar = sb.substring(0, sb.length() - 2);
        return aRetornar + "]";
    }
}

