/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.rs;

import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.UserSystem;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.JsonUtils;
import br.com.jarch.util.LogUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.xml.bind.DatatypeConverter;
import java.security.Key;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.crypto.spec.SecretKeySpec;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static String generate(String secret, String issuer, LocalDateTime expiration) {
        try {
            SignatureAlgorithm algoritimoAssinatura = SignatureAlgorithm.HS256;
            byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)secret);
            SecretKeySpec key = new SecretKeySpec(apiKeySecretBytes, algoritimoAssinatura.getJcaName());
            JwtBuilder construtor = Jwts.builder().setIssuedAt(DateUtils.toDate((LocalDateTime)LocalDateTime.now())).setIssuer(issuer).signWith((Key)key, algoritimoAssinatura).setExpiration(DateUtils.toDate((LocalDateTime)expiration));
            return construtor.compact();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
            throw ex;
        }
    }

    public static void validation(String secret, ContainerRequestContext containerRequestContext) {
        try {
            String token = TokenUtils.getTokenFromContainerRequest(containerRequestContext);
            Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secret)).parseClaimsJws(token).getBody();
            if (claims == null) {
                throw new ValidationException("Token inv\u00e1lido");
            }
            TokenUtils.modificarRequestContext(containerRequestContext, claims.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build());
        }
    }

    public static String getIssuer(String secret, String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secret)).parseClaimsJws(token).getBody();
        if (claims == null) {
            throw new ValidationException("Token inv\u00e1lido");
        }
        return claims.getIssuer();
    }

    public static String getTokenUserSystem(String secret) {
        String jsonUsuarioTo = JsonUtils.toJson((Object)UserSystem.get());
        return TokenUtils.generate(secret, jsonUsuarioTo, LocalDate.now().atTime(LocalTime.MAX));
    }

    public static String getTokenUserSystemWithBearer(String secret) {
        String jsonUsuarioTo = JsonUtils.toJson((Object)UserSystem.get());
        String token = TokenUtils.generate(secret, jsonUsuarioTo, LocalDateTime.now().withHour(23).withMinute(59).withSecond(59));
        return "Bearer " + token;
    }

    public static String getTokenFromContainerRequest(ContainerRequestContext containerRequestContext) {
        String authorizationHeader = containerRequestContext.getHeaderString("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
            throw new NotAuthorizedException((Object)"Authorization header precisa ser provido", new Object[0]);
        }
        return authorizationHeader.substring("Bearer".length()).trim();
    }

    private static void modificarRequestContext(ContainerRequestContext requestContext, final String id) {
        final SecurityContext currentSecurityContext = requestContext.getSecurityContext();
        requestContext.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return () -> id;
            }

            public boolean isUserInRole(String role) {
                return true;
            }

            public boolean isSecure() {
                return currentSecurityContext.isSecure();
            }

            public String getAuthenticationScheme() {
                return "Bearer";
            }
        });
    }
}

