/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.parameter;

import br.com.jarch.core.annotation.JArchValidExclusives;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.entity.CrudEntity;
import br.com.jarch.core.crud.parameter.BaseParameterJpaListener;
import br.com.jarch.core.crud.parameter.IBaseParameterEntity;
import br.com.jarch.core.crud.parameter.IParameterValue;
import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import org.hibernate.envers.Audited;

@MappedSuperclass
@Audited
@JArchValidExclusives(fields={"multiTenantId", "sistema", "chave"})
@EntityListeners(value={BaseParameterJpaListener.class})
@Cacheable
public abstract class BaseParameterEntity
extends CrudEntity
implements IBaseParameterEntity,
IParameterValue {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="ParametroAplicacaoIdSequence")
    @Column(name="id_parametro")
    private Long id;
    @Column(name="cd_chave", nullable=false, length=250)
    @JArchValidRequired(value="label.chave")
    @Size(max=250, message="{message.maxSizeExceeded}")
    private @Size(max=250, message="{message.maxSizeExceeded}") String chave;
    @Column(name="cn_numero")
    private BigInteger conteudoNumero;
    @Column(name="cn_decimal")
    private BigDecimal conteudoDecimal;
    @Column(name="cn_tempo")
    @Convert(converter=LocalDateTimeJpaConverter.class)
    private LocalDateTime conteudoTempo;
    @Column(name="cn_caracter")
    private String conteudoCaracter;
    @Column(name="cn_memo")
    private String conteudoMemo;
    @Column(name="bi_conteudo")
    private byte[] conteudoBinario;
    @Column(name="nm_classseconteudo", nullable=false)
    @JArchValidRequired(value="label.classeConteudo")
    private String classeConteudo;
    @Column(name="ds_parametro", nullable=false, length=100)
    @JArchValidRequired(value="label.descricao")
    private String descricao;
    @Column(name="mm_explicacao", nullable=false, length=4000)
    @JArchValidRequired(value="label.explicacao")
    private String explicacao;
    @Column(name="ds_outrasinformacoes")
    private String outrasInformacoes;
    @Column(name="nm_sistema", nullable=false, length=100)
    @JArchValidRequired(value="label.sistema")
    private String sistema;
    @Column(name="nm_categoria", nullable=false, length=50)
    @JArchValidRequired(value="label.categoria")
    @Size(max=250, message="{message.maxSizeExceeded}")
    private @Size(max=250, message="{message.maxSizeExceeded}") String categoria;
    @Column(name="id_multitenant")
    private long multiTenantId;
    @Column(name="sn_global", nullable=false)
    @JArchValidRequired(value="label.global")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean global = false;
    @Column(name="sn_multitenant", nullable=false)
    @JArchValidRequired(value="label.multitenant")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean multiTenant = true;
    @Column(name="sn_temporal", nullable=false)
    @JArchValidRequired(value="label.temporal")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean temporal = false;
    @Column(name="sn_interno", nullable=false)
    @JArchValidRequired(value="label.interno")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean interno = false;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getChave() {
        return this.chave;
    }

    @Override
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Override
    public BigInteger getValueInteger() {
        return this.conteudoNumero;
    }

    @Override
    public void setValueInteger(BigInteger valueInteger) {
        this.conteudoNumero = valueInteger;
    }

    @Override
    public BigDecimal getValueDecimal() {
        return this.conteudoDecimal;
    }

    @Override
    public void setValueDecimal(BigDecimal valueDecimal) {
        this.conteudoDecimal = valueDecimal;
    }

    @Override
    public LocalDateTime getValueDateTime() {
        return this.conteudoTempo;
    }

    @Override
    public void setValueDateTime(LocalDateTime valueDateTime) {
        this.conteudoTempo = valueDateTime;
    }

    @Override
    public String getValueString() {
        return this.conteudoCaracter;
    }

    @Override
    public void setValueString(String valueString) {
        this.conteudoCaracter = valueString;
    }

    @Override
    public String getValueMemo() {
        return this.conteudoMemo;
    }

    @Override
    public void setValueMemo(String conteudoMemo) {
        this.conteudoMemo = conteudoMemo;
    }

    @Override
    public byte[] getValueBinary() {
        return this.conteudoBinario;
    }

    @Override
    public void setValueBinary(byte[] valueBinary) {
        this.conteudoBinario = valueBinary;
    }

    @Override
    public String getClasseConteudo() {
        return this.classeConteudo;
    }

    @Override
    public void setClasseConteudo(String classeConteudo) {
        this.classeConteudo = classeConteudo;
    }

    @Override
    public String getDescription() {
        return this.descricao;
    }

    @Override
    public void setDescription(String descricao) {
        this.descricao = descricao;
    }

    @Override
    public String getExplanation() {
        return this.explicacao;
    }

    @Override
    public void setExplanation(String explicacao) {
        this.explicacao = explicacao;
    }

    @Override
    public String getValueOtherInformation() {
        return this.outrasInformacoes;
    }

    @Override
    public void setValueOtherInformation(String valueOtherInformation) {
        this.outrasInformacoes = valueOtherInformation;
    }

    @Override
    public String getSistema() {
        return this.sistema;
    }

    @Override
    public void setSistema(String sistema) {
        this.sistema = sistema;
    }

    @Override
    public String getCategoria() {
        return this.categoria;
    }

    @Override
    public void setCategoria(String categoria) {
        this.categoria = categoria;
    }

    @Override
    public long getMultiTenantId() {
        return this.multiTenantId;
    }

    @Override
    public void setMultiTenantId(long multiTenantId) {
        this.multiTenantId = multiTenantId;
    }

    @Override
    public Boolean getGlobal() {
        return this.global;
    }

    @Override
    public void setGlobal(Boolean global) {
        this.global = global;
    }

    @Override
    public Boolean getMultiTenant() {
        return this.multiTenant;
    }

    @Override
    public boolean isMultiTenant() {
        return this.multiTenant != null && this.multiTenant != false;
    }

    @Override
    public void setMultiTenant(Boolean multiTenant) {
        this.multiTenant = multiTenant;
    }

    @Override
    public Boolean getInterno() {
        return this.interno;
    }

    @Override
    public boolean isInterno() {
        return this.interno != null && this.interno != false;
    }

    @Override
    public void setInterno(Boolean interno) {
        this.interno = interno;
    }

    @Override
    public Boolean getTemporal() {
        return this.temporal;
    }

    @Override
    public boolean isTemporal() {
        return this.temporal != null && this.temporal != false;
    }

    @Override
    public void setTemporal(Boolean temporal) {
        this.temporal = temporal;
    }
}

