/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.jparepository;

import br.com.jarch.core.annotation.JArchEventReadEntityManager;
import br.com.jarch.core.crud.util.AutoIncrementUtils;
import br.com.jarch.core.jpa.api.ClientJpql;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Arrays;

@Dependent
public class EntityManagerProduces {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    @JArchEventReadEntityManager
    private Event<EntityManager> eventProduceEntityManager;

    @Produces
    public EntityManager createEntityManager(InjectionPoint injectionPoint) {
        if (!EntityManagerProduces.isClientJpql() && !EntityManagerProduces.isAutoIncrementUtils() && injectionPoint.getMember() == null) {
            LogUtils.warning((String)"WESA: Ponto de inje\u00e7\u00e3o do EntityManager desconhecido, utilizar EntityManagerUtils.addFilter para garantir os filtros necess\u00e1rios...");
        }
        this.eventProduceEntityManager.fire((Object)this.entityManager);
        return this.entityManager;
    }

    private static boolean isClientJpql() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return Arrays.stream(ste).anyMatch(p -> p.getClassName().contains(ClientJpql.class.getSimpleName()));
    }

    private static boolean isAutoIncrementUtils() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return Arrays.stream(ste).anyMatch(p -> p.getClassName().contains(AutoIncrementUtils.class.getSimpleName()));
    }
}

