/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.util.StringUtils;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;

@Dependent
@Named
public class EnvironmentUtils {
    public static final String JARCH_ENVIRONMENT_LOCAL = "JARCH.ENVIRONMENT.LOCAL";
    public static final String JARCH_ENVIROMENT_LOCAL = "JARCH.ENVIROMENT.LOCAL";

    public static boolean isDevelopment() {
        String result = EnvironmentUtils.getProperty(JARCH_ENVIRONMENT_LOCAL, "");
        if (StringUtils.isNotEmpty((String)result)) {
            return result.equals("DEV");
        }
        result = EnvironmentUtils.getProperty(JARCH_ENVIROMENT_LOCAL, "");
        return result.equals("DEV");
    }

    public static boolean isHomologation() {
        return EnvironmentUtils.getProperty(JARCH_ENVIRONMENT_LOCAL, "").equals("HML");
    }

    public static boolean isProduction() {
        return EnvironmentUtils.getProperty(JARCH_ENVIRONMENT_LOCAL, "").equals("PRD");
    }

    public static String getNameWar() {
        return EnvironmentUtils.getNameWar(EnvironmentUtils.class);
    }

    public static String getNameWar(Class<?> clazz) {
        return clazz.getClassLoader().getName().replace("deployment.", "").replace(".war", "");
    }

    public static String getProperty(String key) {
        return EnvironmentUtils.getProperty(key, "");
    }

    public static String getProperty(String key, String defaultValue) {
        return EnvironmentUtils.getProperty(key, null, defaultValue);
    }

    public static String getProperty(String baseKey, String subKey, String defaultValue) {
        Object baseKeyWarSubKey = baseKey + "[" + EnvironmentUtils.getNameWar() + "][" + subKey + "]";
        Object keyWar = baseKey + "[" + EnvironmentUtils.getNameWar() + "]";
        String key = baseKey;
        String value = System.getProperty((String)baseKeyWarSubKey);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        value = System.getProperty((String)keyWar);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        value = System.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        baseKeyWarSubKey = ((String)baseKeyWarSubKey).replace(".", "_").replace("[", "_").replace("]", "_");
        keyWar = ((String)keyWar).replace(".", "_").replace("[", "_").replace("]", "_");
        key = key.replace(".", "_").replace("[", "_").replace("]", "_");
        value = System.getenv((String)baseKeyWarSubKey);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        value = System.getenv((String)keyWar);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        value = System.getenv(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return defaultValue;
    }
}

