/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.type;

import br.com.jarch.core.jpa.param.ParamFieldValue;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.JpqlUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

public enum ConditionSearchType {
    LARGER("label.maior", ">"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            if (valueFilter instanceof Number) {
                return ((Number)valueRecno).doubleValue() > ((Number)valueFilter).doubleValue();
            }
            if (valueFilter instanceof Date) {
                return ((Date)valueRecno).after((Date)valueFilter);
            }
            if (valueFilter instanceof LocalDate) {
                return ((LocalDate)valueRecno).isAfter((LocalDate)valueFilter);
            }
            if (valueFilter instanceof LocalDateTime) {
                return ((LocalDateTime)valueRecno).isAfter((LocalDateTime)valueFilter);
            }
            return valueRecno.toString().toLowerCase().compareTo(valueFilter.toString().toLowerCase()) > 0;
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    LESS("label.menor", "<"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            if (valueFilter instanceof Number) {
                return ((Number)valueRecno).doubleValue() < ((Number)valueFilter).doubleValue();
            }
            if (valueFilter instanceof Date) {
                return ((Date)valueRecno).before((Date)valueFilter);
            }
            if (valueFilter instanceof LocalDate) {
                return ((LocalDate)valueRecno).isBefore((LocalDate)valueFilter);
            }
            if (valueFilter instanceof LocalDateTime) {
                return ((LocalDateTime)valueRecno).isBefore((LocalDateTime)valueFilter);
            }
            return valueRecno.toString().toLowerCase().compareTo(valueFilter.toString().toLowerCase()) < 0;
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    EQUAL("label.igual", "="){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return valueRecno.toString().equalsIgnoreCase(valueFilter.toString());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            if (this.isValueNullOrValueEmptyCollection(paramFieldValue)) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " IS NULL";
            }
            if (Collection.class.isAssignableFrom(paramFieldValue.getValue().getClass())) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " IN (:" + paramFieldValue.getNameParameterJpql() + ")";
            }
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }

        private boolean isValueNullOrValueEmptyCollection(ParamFieldValue paramFieldValue) {
            return paramFieldValue.getValue() == null || paramFieldValue.getValue() != null && Collection.class.isAssignableFrom(paramFieldValue.getValue().getClass()) && ((Collection)paramFieldValue.getValue()).isEmpty();
        }
    }
    ,
    DIFFERENT("label.diferente", "!="){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return !valueRecno.toString().equalsIgnoreCase(valueFilter.toString());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            if (paramFieldValue.getValue() == null) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " IS NOT NULL";
            }
            if (Collection.class.isAssignableFrom(paramFieldValue.getValue().getClass())) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " NOT IN (:" + paramFieldValue.getNameParameterJpql() + ")";
            }
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    LARGER_EQUAL("label.maiorIgual", ">="){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            if (valueRecno.equals(valueFilter)) {
                return true;
            }
            if (valueFilter instanceof Date) {
                return ((Date)valueRecno).after((Date)valueFilter);
            }
            if (valueFilter instanceof LocalDate) {
                return ((LocalDate)valueRecno).isAfter((LocalDate)valueFilter);
            }
            if (valueFilter instanceof LocalDateTime) {
                return ((LocalDateTime)valueRecno).isAfter((LocalDateTime)valueFilter);
            }
            return valueRecno.toString().toLowerCase().compareTo(valueFilter.toString().toLowerCase()) >= 0;
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    LESS_EQUAL("label.igualMenor", "<="){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            if (valueRecno.equals(valueFilter)) {
                return true;
            }
            if (valueFilter instanceof Date) {
                return ((Date)valueRecno).before((Date)valueFilter);
            }
            if (valueFilter instanceof LocalDate) {
                return ((LocalDate)valueRecno).isBefore((LocalDate)valueFilter);
            }
            if (valueFilter instanceof LocalDateTime) {
                return ((LocalDateTime)valueRecno).isBefore((LocalDateTime)valueFilter);
            }
            return valueRecno.toString().toLowerCase().compareTo(valueFilter.toString().toLowerCase()) <= 0;
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    STARTS_WITH("label.inicia", "LIKE"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return valueFilter.toString().toLowerCase().startsWith(valueRecno.toString().toLowerCase());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    CONTAINS("label.contem", "LIKE"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return valueFilter.toString().toLowerCase().contains(valueRecno.toString().toLowerCase());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            if (paramFieldValue.getValue() == null) {
                return "";
            }
            if (Collection.class.isAssignableFrom(paramFieldValue.getValue().getClass())) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " IN (:" + paramFieldValue.getNameParameterJpql() + ")";
            }
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    NOT_CONTAINS("label.naoContem", "NOT LIKE"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return !valueFilter.toString().toLowerCase().contains(valueRecno.toString().toLowerCase());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            if (paramFieldValue.getValue() == null) {
                return "";
            }
            if (Collection.class.isAssignableFrom(paramFieldValue.getValue().getClass())) {
                return ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute() + " NOT IN (:" + paramFieldValue.getNameParameterJpql() + ")";
            }
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    ENDS_WITH("label.termina", "LIKE"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            if (valueFilter == null || valueRecno == null) {
                return true;
            }
            return valueFilter.toString().toLowerCase().endsWith(valueRecno.toString().toLowerCase());
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateFieldConditionValue(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    EXISTS("label.existe", "EXISTS (FROM %s)"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return String.format(paramFieldValue.getConditionSearch().getJpql(), ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute());
        }
    }
    ,
    NOT_EXISTS("label.naoExiste", "NOT EXISTS (FROM %s)"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return NOT_CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return String.format(paramFieldValue.getConditionSearch().getJpql(), ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute());
        }
    }
    ,
    EMPTY("label.existe", "%s IS EMPTY"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return String.format(paramFieldValue.getConditionSearch().getJpql(), ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute());
        }
    }
    ,
    NOT_EMPTY("label.naoExiste", "%s IS NOT EMPTY"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return NOT_CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return String.format(paramFieldValue.getConditionSearch().getJpql(), ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute());
        }
    }
    ,
    MEMBER_OF("label.existe", "MEMBER OF"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateValueConditionField(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    NOT_MEMBER_OF("label.naoExiste", "NOT MEMBER OF"){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return NOT_CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return ConditionSearchType.generateValueConditionField(clazzEntity, paramFieldValue, aliases);
        }
    }
    ,
    JPQL("label.concatenaWhere", ""){

        @Override
        public boolean validTargetValue(Object valueRecno, Object valueFilter) {
            return CONTAINS.validTargetValue(valueFilter, valueRecno);
        }

        @Override
        public String generateConditionWhereJpql(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
            return paramFieldValue.getClause();
        }
    };

    private final String description;
    private final String jpql;

    public abstract boolean validTargetValue(Object var1, Object var2);

    public abstract String generateConditionWhereJpql(Class<?> var1, ParamFieldValue var2, Collection<String> var3);

    private ConditionSearchType(String description, String jpql) {
        this.description = description;
        this.jpql = jpql;
    }

    public static Collection<ConditionSearchType> equalAndDifferent() {
        return Arrays.stream(ConditionSearchType.values()).filter(c -> c.equals((Object)EQUAL) || c.equals((Object)DIFFERENT)).collect(Collectors.toList());
    }

    public static Collection<ConditionSearchType> allMinusContainsExistsStartsEnds() {
        return Arrays.stream(ConditionSearchType.values()).filter(c -> !c.equals((Object)CONTAINS) && !c.equals((Object)NOT_CONTAINS)).filter(c -> !c.equals((Object)EXISTS) && !c.equals((Object)NOT_EXISTS)).filter(c -> !c.equals((Object)JPQL)).filter(c -> !c.equals((Object)STARTS_WITH) && !c.equals((Object)ENDS_WITH)).filter(c -> !c.equals((Object)MEMBER_OF) && !c.equals((Object)NOT_MEMBER_OF)).filter(c -> !c.equals((Object)EMPTY) && !c.equals((Object)NOT_EMPTY)).collect(Collectors.toList());
    }

    public static Collection<ConditionSearchType> equalAndDifferentAndContainsAndStartsAndEnds() {
        return Arrays.stream(ConditionSearchType.values()).filter(c -> c.equals((Object)EQUAL) || c.equals((Object)DIFFERENT) || c.equals((Object)CONTAINS) || c.equals((Object)NOT_CONTAINS) || c.equals((Object)STARTS_WITH) || c.equals((Object)ENDS_WITH)).collect(Collectors.toList());
    }

    public static Collection<ConditionSearchType> containsAndStartsAndEnds() {
        return Arrays.stream(ConditionSearchType.values()).filter(c -> c.equals((Object)CONTAINS) || c.equals((Object)NOT_CONTAINS) || c.equals((Object)STARTS_WITH) || c.equals((Object)ENDS_WITH)).collect(Collectors.toList());
    }

    public static Collection<ConditionSearchType> contains() {
        return Arrays.stream(ConditionSearchType.values()).filter(c -> c.equals((Object)CONTAINS) || c.equals((Object)NOT_CONTAINS)).collect(Collectors.toList());
    }

    public static Collection<ConditionSearchType> all() {
        return Arrays.stream(ConditionSearchType.values()).collect(Collectors.toList());
    }

    public String getDescription() {
        return BundleUtils.messageBundle(this.description);
    }

    public String getJpql() {
        return this.jpql;
    }

    private static String generateFieldConditionValue(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
        return (paramFieldValue.isCaseSensitive() ? "" : "LOWER(").concat(ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute()).concat(paramFieldValue.isCaseSensitive() ? "" : ")").concat(" ").concat(paramFieldValue.getConditionSearch().getJpql()).concat(" ").concat(paramFieldValue.isCaseSensitive() ? "" : "LOWER(").concat(":").concat(paramFieldValue.getNameParameterJpql()).concat(paramFieldValue.isCaseSensitive() ? "" : ")");
    }

    private static String generateValueConditionField(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
        return (paramFieldValue.isCaseSensitive() ? "" : "LOWER(").concat(":").concat(paramFieldValue.getNameParameterJpql()).concat(paramFieldValue.isCaseSensitive() ? "" : ")").concat(" ").concat(paramFieldValue.getConditionSearch().getJpql()).concat(" ").concat(paramFieldValue.isCaseSensitive() ? "" : "LOWER(").concat(ConditionSearchType.addPrefix(clazzEntity, paramFieldValue, aliases) + paramFieldValue.getAttribute()).concat(paramFieldValue.isCaseSensitive() ? "" : ")");
    }

    private static String addPrefix(Class<?> clazzEntity, ParamFieldValue paramFieldValue, Collection<String> aliases) {
        String prefix = JpqlUtils.aliasEntity(clazzEntity);
        if (paramFieldValue.getAttribute() == null || paramFieldValue.getAttribute().startsWith(prefix.concat(".")) || !paramFieldValue.isPrefixField() || paramFieldValue.isPrefixFieldStartedAlias(aliases)) {
            return "";
        }
        return paramFieldValue.getAttribute().equals(prefix) ? "" : prefix + ".";
    }
}

