/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.report;

import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Date;

public class ReportUtils {
    private ReportUtils() {
    }

    public static AbstractColumn findColumn(DynamicReportBuilder dynamicReportBuilder, String attribute) {
        return dynamicReportBuilder.getColumns().stream().filter(column -> ((SimpleColumn)column).getColumnProperty().getProperty().equals(attribute)).findFirst().orElse(null);
    }

    public static Style cloneStyleRight(Style style) {
        try {
            Style styleRight = (Style)style.clone();
            styleRight.setHorizontalAlign(HorizontalAlign.RIGHT);
            return styleRight;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return style;
        }
    }

    public static Style cloneStyleCenter(Style style) {
        try {
            Style styleRight = (Style)style.clone();
            styleRight.setHorizontalAlign(HorizontalAlign.CENTER);
            return styleRight;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return style;
        }
    }

    public static void format(Class<?> type, AbstractColumn abstractColumn, Style styleColumnHeader, Style styleDetail) {
        if (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            abstractColumn.setPattern("0");
            abstractColumn.setHeaderStyle(ReportUtils.cloneStyleRight(styleColumnHeader));
            abstractColumn.setStyle(ReportUtils.cloneStyleRight(styleDetail));
        } else if (Number.class.isAssignableFrom(type)) {
            abstractColumn.setPattern("#,##0.00");
            abstractColumn.setHeaderStyle(ReportUtils.cloneStyleRight(styleColumnHeader));
            abstractColumn.setStyle(ReportUtils.cloneStyleRight(styleDetail));
        } else if (Date.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type)) {
            abstractColumn.setPattern("dd/MM/yyyy");
            abstractColumn.setHeaderStyle(ReportUtils.cloneStyleCenter(styleColumnHeader));
            abstractColumn.setStyle(ReportUtils.cloneStyleCenter(styleDetail));
        } else if (LocalDateTime.class.isAssignableFrom(type)) {
            abstractColumn.setPattern("dd/MM/yyyy HH:mm");
            abstractColumn.setHeaderStyle(ReportUtils.cloneStyleCenter(styleColumnHeader));
            abstractColumn.setStyle(ReportUtils.cloneStyleCenter(styleDetail));
        } else if (YearMonth.class.isAssignableFrom(type)) {
            abstractColumn.setPattern("MM/yyyy");
            abstractColumn.setHeaderStyle(ReportUtils.cloneStyleCenter(styleColumnHeader));
            abstractColumn.setStyle(ReportUtils.cloneStyleCenter(styleDetail));
        }
    }
}

